/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.storage;

import ch.systemsx.cisd.bds.storage.INode;
import ch.systemsx.cisd.bds.storage.INodeFilter;

public final class NodeFilters {
    public static final INodeFilter TRUE_NODE_FILTER = new INodeFilter(){

        public final boolean accept(INode node) {
            return true;
        }
    };

    private NodeFilters() {
    }

    public static final INodeFilter createExtensionNodeFilter(boolean ignoreCase, String ... extensions) {
        assert (extensions != null) : "Given extensions can not be null.";
        return new SuffixNodeFilter(ignoreCase, NodeFilters.toSuffixes(extensions));
    }

    private static final String[] toSuffixes(String ... extensions) {
        int length = extensions.length;
        String[] suffixes = new String[length];
        int i = 0;
        while (i < length) {
            suffixes[i] = "." + extensions[i];
            ++i;
        }
        return suffixes;
    }

    private static final class SuffixNodeFilter
    implements INodeFilter {
        private final String[] suffixes;
        private final boolean ignoreCase;

        SuffixNodeFilter(boolean ignoreCase, String ... suffixes) {
            assert (suffixes != null) : "Suffixes can not be null.";
            this.suffixes = suffixes;
            this.ignoreCase = ignoreCase;
        }

        public final boolean accept(INode node) {
            assert (node != null) : "Given node can not be null.";
            String nameWithRightCase = this.toRightCase(node.getName());
            String[] stringArray = this.suffixes;
            int n = this.suffixes.length;
            int n2 = 0;
            while (n2 < n) {
                String suffix = stringArray[n2];
                String suffixWithRightCase = this.toRightCase(suffix);
                if (nameWithRightCase.endsWith(suffixWithRightCase)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private final String toRightCase(String s) {
            if (this.ignoreCase) {
                return s.toLowerCase();
            }
            return s;
        }
    }
}

