/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.storage.filesystem;

import ch.systemsx.cisd.bds.exception.StorageException;
import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.IFileBasedNode;
import ch.systemsx.cisd.bds.storage.filesystem.NodeFactory;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import java.io.File;
import org.apache.commons.lang.ObjectUtils;

abstract class AbstractNode
implements IFileBasedNode {
    protected final File nodeFile;

    protected static final File moveFileToDirectory(File source, File directory, String nameOrNull) throws EnvironmentFailureException {
        boolean successful;
        assert (source != null);
        assert (directory != null && FileOperations.getMonitoredInstanceForCurrentThread().isDirectory(directory));
        String newName = nameOrNull == null ? source.getName() : nameOrNull;
        File destination = new File(directory, newName);
        if (!FileOperations.getMonitoredInstanceForCurrentThread().exists(destination) && !(successful = FileOperations.getMonitoredInstanceForCurrentThread().rename(source, destination))) {
            throw EnvironmentFailureException.fromTemplate("Can not move file '%s' to directory '%s'.", source.getAbsolutePath(), directory.getAbsolutePath());
        }
        return destination;
    }

    AbstractNode(File file) {
        AbstractNode.checkFile(file);
        this.nodeFile = file;
    }

    static void checkFile(File file) {
        if (file == null) {
            throw new StorageException("Unspecified file.");
        }
        if (!FileOperations.getMonitoredInstanceForCurrentThread().exists(file)) {
            throw new StorageException(String.format("Non existing file '%s'.", file.getAbsolutePath()));
        }
    }

    public File getNodeFile() {
        return this.nodeFile;
    }

    public final String getName() {
        return this.nodeFile.getName();
    }

    public String getPath() {
        return this.nodeFile.getAbsolutePath();
    }

    public final IDirectory tryGetParent() {
        File dir = this.nodeFile.getParentFile();
        return dir == null ? null : NodeFactory.internalCreateDirectoryNode(dir);
    }

    public final void moveTo(File directory) {
        AbstractNode.moveFileToDirectory(this.nodeFile, directory, null);
    }

    public boolean isValid() {
        return FileOperations.getMonitoredInstanceForCurrentThread().canRead(this.nodeFile);
    }

    public final String toString() {
        return this.nodeFile.getAbsolutePath();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IFileBasedNode)) {
            return false;
        }
        return ObjectUtils.equals((Object)this.nodeFile, (Object)((IFileBasedNode)obj).getNodeFile());
    }

    public int hashCode() {
        return this.nodeFile.hashCode();
    }
}

