/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.storage.filesystem;

import ch.systemsx.cisd.bds.exception.StorageException;
import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.IFile;
import ch.systemsx.cisd.bds.storage.IFileBasedDirectory;
import ch.systemsx.cisd.bds.storage.IFileBasedFile;
import ch.systemsx.cisd.bds.storage.IFileBasedLink;
import ch.systemsx.cisd.bds.storage.IFileBasedNode;
import ch.systemsx.cisd.bds.storage.ILink;
import ch.systemsx.cisd.bds.storage.INode;
import ch.systemsx.cisd.bds.storage.filesystem.AbstractNode;
import ch.systemsx.cisd.bds.storage.filesystem.LinkMakerProvider;
import ch.systemsx.cisd.bds.storage.filesystem.NodeFactory;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.WrappedIOException;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Directory
extends AbstractNode
implements IFileBasedDirectory {
    Directory(File directory) {
        super(directory);
        if (!FileOperations.getMonitoredInstanceForCurrentThread().isDirectory(directory)) {
            throw new StorageException(String.format("Not a directory '%s'.", directory.getAbsolutePath()));
        }
    }

    private static final File getNodeFile(INode node) {
        assert (node instanceof IFileBasedNode) : "Must be an instance of IFileBasedNode.";
        return ((IFileBasedNode)node).getNodeFile();
    }

    private static final String cleanName(String name) {
        int index = name.indexOf(47);
        if (index == 0) {
            return name.substring(1);
        }
        return name;
    }

    @Override
    public IDirectory tryAsDirectory() {
        return this;
    }

    @Override
    public IFile tryAsFile() {
        return null;
    }

    @Override
    public final INode tryGetNode(String name) {
        assert (name != null) : "Given name can not be null.";
        String path = Directory.cleanName(name.replace('\\', '/'));
        File childrenNodeFile = new File(this.nodeFile, path);
        if (FileOperations.getMonitoredInstanceForCurrentThread().exists(childrenNodeFile)) {
            return NodeFactory.internalCreateNode(childrenNodeFile);
        }
        return null;
    }

    @Override
    public final IDirectory makeDirectory(String name) {
        assert (name != null) : "Given name can not be null.";
        File dir = new File(this.nodeFile, name);
        if (FileOperations.getMonitoredInstanceForCurrentThread().exists(dir)) {
            if (!FileOperations.getMonitoredInstanceForCurrentThread().isDirectory(dir)) {
                throw new StorageException("There already exists a file named '" + name + "' in directory " + this);
            }
            return NodeFactory.internalCreateDirectoryNode(dir);
        }
        boolean successful = FileOperations.getMonitoredInstanceForCurrentThread().mkdir(dir);
        if (!successful) {
            throw new EnvironmentFailureException("Couldn't create directory " + dir.getAbsolutePath() + " for some unknown reason.");
        }
        return NodeFactory.internalCreateDirectoryNode(dir);
    }

    @Override
    public final IFile addKeyValuePair(String key, String value) {
        assert (key != null) : "Given key can not be null.";
        if (value == null) {
            throw new IllegalArgumentException("Value for key '" + key + "' not specified.");
        }
        File file = new File(this.nodeFile, key);
        FileOperations.getMonitoredInstanceForCurrentThread().writeToFile(file, value);
        return NodeFactory.internalCreateFileNode(file);
    }

    @Override
    public final INode addFile(File file, String name, boolean move) {
        Directory.checkFile(file);
        String fileName = name == null ? file.getName() : name;
        File newFile = new File(this.nodeFile, fileName);
        if (move) {
            Directory.moveFileToDirectory(file, this.nodeFile, name);
        } else {
            try {
                if (FileOperations.getMonitoredInstanceForCurrentThread().isDirectory(file)) {
                    FileOperations.getMonitoredInstanceForCurrentThread().copyDirectory(file, newFile);
                } else {
                    FileOperations.getMonitoredInstanceForCurrentThread().copyFile(file, newFile);
                }
            }
            catch (WrappedIOException ex) {
                throw EnvironmentFailureException.fromTemplate(ex, "Can not copy file '%s' to directory '%s'.", file, this.nodeFile.getAbsolutePath());
            }
        }
        return NodeFactory.internalCreateNode(newFile);
    }

    @Override
    public final ILink tryAddLink(String name, INode node) {
        assert (node != null) : "Node can not be null.";
        assert (name != null) : "Name can not be null.";
        File file = Directory.getNodeFile(node);
        boolean ok = LinkMakerProvider.getLinkMaker().copyImmutably(file, this.nodeFile, name);
        if (ok) {
            IFileBasedLink link = (IFileBasedLink)NodeFactory.createLinkNode(name, file);
            link.setParent(this);
            return link;
        }
        return null;
    }

    @Override
    public final Iterator<INode> iterator() {
        return new Iterator<INode>(){
            private List<File> files;
            private int index;
            {
                this.files = FileOperations.getMonitoredInstanceForCurrentThread().listFilesAndDirectories(Directory.this.nodeFile, false);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public INode next() {
                return this.index >= this.files.size() ? null : NodeFactory.internalCreateNode(this.files.get(this.index++));
            }

            @Override
            public boolean hasNext() {
                return this.index < this.files.size();
            }
        };
    }

    @Override
    public final void extractTo(File directory) throws EnvironmentFailureException {
        assert (directory != null) : "Directory could not be null";
        try {
            FileOperations.getMonitoredInstanceForCurrentThread().copyDirectoryToDirectory(this.nodeFile, directory);
        }
        catch (WrappedIOException ex) {
            throw EnvironmentFailureException.fromTemplate(ex, "Can not copy directory '%s' to directory '%s'.", this.nodeFile.getAbsolutePath(), directory.getAbsolutePath());
        }
    }

    @Override
    public final void removeNode(INode node) {
        assert (node != null) : "Node could not be null";
        File file = Directory.getNodeFile(node);
        if (FileOperations.getMonitoredInstanceForCurrentThread().isDirectory(file)) {
            try {
                FileOperations.getMonitoredInstanceForCurrentThread().deleteRecursively(file);
            }
            catch (WrappedIOException wrappedIOException) {
                throw EnvironmentFailureException.fromTemplate("Can not remove directory '%s'.", file.getAbsolutePath());
            }
        } else if (FileOperations.getMonitoredInstanceForCurrentThread().isFile(file) && !FileOperations.getMonitoredInstanceForCurrentThread().delete(file)) {
            throw EnvironmentFailureException.fromTemplate("Can not remove file '%s'.", file.getAbsolutePath());
        }
    }

    @Override
    public List<IFile> listFiles(String[] extensionsOrNull, boolean recursive) {
        List<File> files = FileOperations.getMonitoredInstanceForCurrentThread().listFiles(this.nodeFile, extensionsOrNull, recursive);
        ArrayList<IFileBasedFile> nodes = new ArrayList<IFileBasedFile>(files.size());
        for (File f : files) {
            nodes.add(NodeFactory.internalCreateFileNode(f));
        }
        return Collections.unmodifiableList(nodes);
    }

    @Override
    public List<IDirectory> listDirectories(boolean recursive) {
        List<File> files = FileOperations.getMonitoredInstanceForCurrentThread().listDirectories(this.nodeFile, recursive);
        ArrayList<IFileBasedDirectory> nodes = new ArrayList<IFileBasedDirectory>(files.size());
        for (File f : files) {
            nodes.add(NodeFactory.internalCreateDirectoryNode(f));
        }
        return Collections.unmodifiableList(nodes);
    }
}

