/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.storage.filesystem;

import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.IFile;
import ch.systemsx.cisd.bds.storage.IFileBasedLink;
import ch.systemsx.cisd.bds.storage.IFileBasedNode;
import ch.systemsx.cisd.bds.storage.INode;
import com.sun.corba.se.impl.orbutil.ObjectUtility;
import java.io.File;

final class Link
implements IFileBasedLink {
    private final String name;
    private final IFileBasedNode reference;
    private IDirectory parent;

    Link(String name, IFileBasedNode reference) {
        assert (name != null) : "A name must be specified.";
        assert (reference != null) : "Reference can not be null.";
        assert (reference instanceof IFile) : "Given reference must be of type IFile: " + reference.getClass().getName();
        assert (reference.isValid()) : "Given reference must be valid: " + reference;
        this.name = name;
        this.reference = reference;
    }

    public final void setParent(IDirectory parentOrNull) {
        this.parent = parentOrNull;
    }

    public IDirectory tryAsDirectory() {
        return this.reference instanceof IDirectory ? (IDirectory)((Object)this.reference) : null;
    }

    public IFile tryAsFile() {
        return this.reference instanceof IFile ? (IFile)((Object)this.reference) : null;
    }

    public final String getName() {
        return this.name;
    }

    public String getPath() {
        return String.valueOf(this.parent.getPath()) + "/" + this.getPath();
    }

    public final IDirectory tryGetParent() {
        return this.parent;
    }

    public final INode getReference() {
        return this.reference;
    }

    public final void extractTo(File directory) {
        this.reference.extractTo(directory);
    }

    public final void moveTo(File directory) {
        this.reference.moveTo(directory);
    }

    public final boolean isValid() {
        if (!this.reference.isValid()) {
            return false;
        }
        if (this.parent != null) {
            INode node = this.parent.tryGetNode(this.name);
            return node != null && node.isValid();
        }
        return true;
    }

    public File getNodeFile() {
        return this.reference.getNodeFile();
    }

    public final String toString() {
        return this.getPath();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IFileBasedLink)) {
            return false;
        }
        return ObjectUtility.equals((Object)this.getPath(), (Object)((IFileBasedLink)obj).getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }
}

