/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.common.filesystem.IFileRemover;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import java.io.File;

public class LoggingPathRemoverDecorator
implements IFileRemover {
    private final IFileRemover delegate;
    private final ISimpleLogger logger;
    private final boolean failuresOnly;

    public LoggingPathRemoverDecorator(IFileRemover delegate, ISimpleLogger logger, boolean failuresOnly) {
        this.delegate = delegate;
        this.logger = logger;
        this.failuresOnly = failuresOnly;
    }

    public boolean removeRecursively(File fileToRemove) {
        boolean ok = this.delegate.removeRecursively(fileToRemove);
        if (this.shouldLog(ok)) {
            this.logger.log(ok ? LogLevel.INFO : LogLevel.ERROR, String.format("Deleting %s '%s': %s.", this.getType(fileToRemove), fileToRemove.getPath(), ok ? "OK" : "FAILED"));
        }
        return ok;
    }

    private boolean shouldLog(boolean ok) {
        return !ok || !this.failuresOnly;
    }

    private String getType(File fileToRemove) {
        return fileToRemove.isDirectory() ? "directory" : "file";
    }
}

