/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.common.TimingParameters;
import ch.systemsx.cisd.common.collections.ExtendedBlockingQueueFactory;
import ch.systemsx.cisd.common.collections.ExtendedLinkedBlockingQueue;
import ch.systemsx.cisd.common.collections.IExtendedBlockingQueue;
import ch.systemsx.cisd.common.collections.PersistentExtendedBlockingQueueDecorator;
import ch.systemsx.cisd.common.collections.RecordBasedQueuePersister;
import ch.systemsx.cisd.common.concurrent.MonitoringProxy;
import ch.systemsx.cisd.common.exceptions.StopException;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.ICloseable;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.filesystem.IFileRemover;
import ch.systemsx.cisd.common.filesystem.LoggingPathRemoverDecorator;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueingPathRemoverService
implements IFileRemover {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, QueueingPathRemoverService.class);
    private static final int INITIAL_RECORD_SIZE = 128;
    static final String SHREDDER_PREFIX = ".SHREDDER_";
    private static final AtomicInteger counter = new AtomicInteger();
    private static IExtendedBlockingQueue<File> queue = null;
    private static ICloseable queueCloseableOrNull = null;
    private static Thread thread = null;
    private static IFileRemover deepRemover = null;
    private static IFileRemover queueingRemover = null;
    private static QueueingPathRemoverService instance = new QueueingPathRemoverService();

    public static final QueueingPathRemoverService getInstance() {
        return instance;
    }

    public static final void start() {
        QueueingPathRemoverService.start(null);
    }

    public static final void start(File queueFileOrNull) {
        QueueingPathRemoverService.start(queueFileOrNull, TimingParameters.getDefaultParameters());
    }

    public static final void start(File queueFileOrNull, TimingParameters parameters) {
        Log4jSimpleLogger logger = new Log4jSimpleLogger(operationLog);
        IFileOperations monitoringProxy = FileOperations.createMonitoredInstance(parameters);
        deepRemover = new LoggingPathRemoverDecorator(monitoringProxy, logger, false);
        queueingRemover = MonitoringProxy.create(IFileRemover.class, new IFileRemover(){

            public boolean removeRecursively(File fileToRemove) {
                if (fileToRemove.isFile()) {
                    return fileToRemove.delete();
                }
                String name = QueueingPathRemoverService.SHREDDER_PREFIX + System.currentTimeMillis() + "-" + counter.incrementAndGet() + "-" + fileToRemove.getName();
                File shredderFile = new File(fileToRemove.getParentFile(), name);
                boolean ok = fileToRemove.renameTo(shredderFile);
                if (ok) {
                    queue.add(shredderFile);
                }
                return ok;
            }
        }).timing(parameters).errorLog(logger).get();
        if (queueFileOrNull != null) {
            PersistentExtendedBlockingQueueDecorator<File> persistentQueue = ExtendedBlockingQueueFactory.createPersistRecordBased(queueFileOrNull, 128);
            queue = persistentQueue;
            queueCloseableOrNull = persistentQueue;
        } else {
            queue = new ExtendedLinkedBlockingQueue<File>();
        }
        thread = new Thread(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        File fileToRemove = (File)queue.peekWait();
                        deepRemover.removeRecursively(fileToRemove);
                        queue.take();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (StopException stopException) {}
            }
        }, "Shredder Queue");
        thread.setDaemon(true);
        thread.start();
    }

    private static final void close() {
        if (queueCloseableOrNull != null) {
            queueCloseableOrNull.close();
        }
    }

    public static final void stop() {
        thread.interrupt();
        QueueingPathRemoverService.close();
        thread = null;
        queue = null;
        queueCloseableOrNull = null;
        deepRemover = null;
    }

    public static final boolean stopAndWait(long timeoutMillis) {
        thread.interrupt();
        try {
            thread.join(timeoutMillis);
        }
        catch (InterruptedException interruptedException) {}
        boolean ok = !thread.isAlive();
        QueueingPathRemoverService.close();
        return ok;
    }

    public static final boolean isRunning() {
        return queueingRemover != null;
    }

    public static final List<File> listShredderItems(File queueFile) {
        return RecordBasedQueuePersister.list(File.class, queueFile);
    }

    private QueueingPathRemoverService() {
    }

    @Override
    public boolean removeRecursively(File fileToRemove) {
        return queueingRemover.removeRecursively(fileToRemove);
    }
}

