/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem.rsync;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.StatusFlag;
import ch.systemsx.cisd.common.filesystem.IPathCopier;
import ch.systemsx.cisd.common.filesystem.rsync.RsyncExitValueTranslator;
import ch.systemsx.cisd.common.filesystem.rsync.RsyncVersionChecker;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.process.ProcessResult;
import ch.systemsx.cisd.common.utilities.IDirectoryImmutableCopier;
import ch.systemsx.cisd.common.utilities.ITerminable;
import ch.systemsx.cisd.common.utilities.OSUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RsyncCopier
implements IPathCopier,
IDirectoryImmutableCopier {
    protected static final Status TERMINATED_STATUS = new Status(StatusFlag.RETRIABLE_ERROR, "Process was terminated.");
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, RsyncCopier.class);
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, RsyncCopier.class);
    private static final Status INTERRUPTED_STATUS = new Status(StatusFlag.RETRIABLE_ERROR, "Process was interrupted.");
    private static final Status TIMEOUT_STATUS = new Status(StatusFlag.RETRIABLE_ERROR, "Process has stopped because of timeout.");
    private final String rsyncExecutable;
    private final RsyncVersionChecker.RsyncVersion rsyncVersion;
    private final String sshExecutable;
    private final List<String> additionalCmdLineFlags;
    private final boolean overwrite;
    private final boolean destinationDirectoryRequiresDeletionBeforeCreation;
    private final AtomicReference<ITerminable> rsyncTerminator;

    public RsyncCopier(File rsyncExecutable) {
        this(rsyncExecutable, null, false, false, new String[0]);
    }

    public RsyncCopier(File rsyncExecutable, File sshExecutableOrNull, boolean destinationDirectoryRequiresDeletionBeforeCreation, boolean overwrite, String ... cmdLineFlags) {
        assert (rsyncExecutable != null && rsyncExecutable.exists());
        assert (sshExecutableOrNull == null || rsyncExecutable.exists());
        this.rsyncExecutable = rsyncExecutable.getAbsolutePath();
        this.rsyncVersion = RsyncVersionChecker.getVersion(rsyncExecutable.getAbsolutePath());
        this.sshExecutable = sshExecutableOrNull != null ? sshExecutableOrNull.getPath() : null;
        this.destinationDirectoryRequiresDeletionBeforeCreation = destinationDirectoryRequiresDeletionBeforeCreation;
        this.overwrite = overwrite;
        this.rsyncTerminator = new AtomicReference<Object>(null);
        this.additionalCmdLineFlags = cmdLineFlags.length > 0 ? Arrays.asList(cmdLineFlags) : null;
    }

    private boolean rsyncSupportsAppend() {
        assert (this.rsyncVersion != null);
        return this.rsyncVersion.isNewerOrEqual(2, 6, 7);
    }

    private boolean isOverwriteMode() {
        return this.overwrite || this.destinationDirectoryRequiresDeletionBeforeCreation || !this.rsyncSupportsAppend();
    }

    @Override
    public final Status copy(File sourcePath, File destinationDirectory) {
        return this.copy(sourcePath, null, destinationDirectory, null);
    }

    @Override
    public final Status copyFromRemote(File sourcePath, String sourceHost, File destinationDirectory) {
        return this.copy(sourcePath, sourceHost, destinationDirectory, null);
    }

    @Override
    public final Status copyToRemote(File sourcePath, File destinationDirectory, String destinationHost) {
        return this.copy(sourcePath, null, destinationDirectory, destinationHost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean copyDirectoryImmutably(File sourceDirectory, File destinationDirectory, String targetNameOrNull) {
        ProcessExecutionHelper.IProcessHandler processHandler;
        assert (sourceDirectory != null);
        assert (sourceDirectory.isDirectory()) : sourceDirectory.getAbsolutePath();
        assert (destinationDirectory != null);
        assert (destinationDirectory.isDirectory()) : destinationDirectory.getAbsolutePath();
        List<String> commandLine = this.createCommandLineForImmutableCopy(sourceDirectory, this.createTargetDirectory(sourceDirectory, destinationDirectory, targetNameOrNull));
        RsyncCopier rsyncCopier = this;
        synchronized (rsyncCopier) {
            processHandler = ProcessExecutionHelper.runUnblocking(commandLine, operationLog, machineLog);
            this.rsyncTerminator.set(processHandler);
        }
        ProcessResult processResult = processHandler.getResult();
        processResult.log();
        return processResult.isOK();
    }

    private File createTargetDirectory(File sourceDirectory, File destinationDirectory, String targetNameOrNull) {
        if (targetNameOrNull == null) {
            return new File(destinationDirectory, sourceDirectory.getName());
        }
        return new File(destinationDirectory, targetNameOrNull);
    }

    @Override
    public final synchronized boolean terminate() {
        ITerminable copyProcess = this.rsyncTerminator.get();
        if (copyProcess != null) {
            return copyProcess.terminate();
        }
        return false;
    }

    private final List<String> createCommandLineForImmutableCopy(File sourcePath, File destinationPath) {
        assert (sourcePath != null);
        assert (destinationPath != null);
        assert (destinationPath.getParentFile().isDirectory()) : destinationPath.getParentFile().getAbsolutePath();
        String absoluteSource = sourcePath.getAbsolutePath();
        ArrayList<String> commandLineList = new ArrayList<String>();
        commandLineList.add(this.rsyncExecutable);
        commandLineList.add("--archive");
        commandLineList.add("--link-dest=" + absoluteSource);
        commandLineList.add(String.valueOf(absoluteSource) + "/");
        commandLineList.add(destinationPath.getAbsolutePath());
        return commandLineList;
    }

    @Override
    public final void check() {
        if (machineLog.isDebugEnabled()) {
            machineLog.debug(String.format("Testing rsync executable '%s'", this.rsyncExecutable));
        }
        if (this.rsyncVersion == null) {
            if (OSUtilities.executableExists(this.rsyncExecutable)) {
                throw new ConfigurationFailureException(String.format("Rsync executable '%s' is invalid.", this.rsyncExecutable));
            }
            throw new ConfigurationFailureException(String.format("Rsync executable '%s' does not exist.", this.rsyncExecutable));
        }
        if (!this.rsyncVersion.isNewerOrEqual(2, 6, 0)) {
            throw new ConfigurationFailureException(String.format("Rsync executable '%s' is too old (required: 2.6.0, found: %s)", this.rsyncExecutable, this.rsyncVersion.getVersionString()));
        }
        if (machineLog.isInfoEnabled()) {
            machineLog.info(String.format("Using rsync executable '%s', version %s, mode: %s", this.rsyncExecutable, this.rsyncVersion.getVersionString(), this.isOverwriteMode() ? "overwrite" : "append"));
        }
        if (this.rsyncVersion.isRsyncPreReleaseVersion()) {
            machineLog.warn(String.format("The rsync executable '%s' is a pre-release version. It is not recommended to use such a version in a production environment.", this.rsyncExecutable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Status copy(File sourcePath, String sourceHostOrNull, File destinationDirectory, String destinationHostOrNull) {
        ProcessExecutionHelper.IProcessHandler processHandler;
        assert (sourcePath != null);
        assert (sourceHostOrNull != null || sourcePath.exists()) : this.logNonExistent(sourcePath);
        assert (destinationDirectory != null);
        assert (destinationHostOrNull != null || destinationDirectory.isDirectory()) : this.logNonExistent(destinationDirectory);
        assert (sourceHostOrNull == null || destinationHostOrNull == null);
        List<String> commandLine = this.createCommandLineForMutableCopy(sourcePath, sourceHostOrNull, destinationDirectory, destinationHostOrNull);
        RsyncCopier rsyncCopier = this;
        synchronized (rsyncCopier) {
            processHandler = ProcessExecutionHelper.runUnblocking(commandLine, operationLog, machineLog);
            this.rsyncTerminator.set(processHandler);
        }
        ProcessResult processResult = processHandler.getResult();
        processResult.log();
        return RsyncCopier.createStatus(processResult);
    }

    private final String logNonExistent(File path) {
        if (path == null) {
            return "null";
        }
        return "path '" + path.getAbsolutePath() + "' does not exist";
    }

    private final List<String> createCommandLineForMutableCopy(File sourcePath, String sourceHost, File destinationDirectory, String destinationHost) {
        assert (sourcePath != null && (sourceHost != null || sourcePath.exists()));
        assert (destinationDirectory != null && (destinationHost != null || destinationDirectory.isDirectory()));
        assert (destinationHost != null && this.sshExecutable != null || destinationHost == null);
        assert (sourceHost != null && this.sshExecutable != null || sourceHost == null);
        List<String> standardParameters = Arrays.asList("--archive", "--delete", "--inplace");
        ArrayList<String> commandLineList = new ArrayList<String>();
        commandLineList.add(this.rsyncExecutable);
        commandLineList.addAll(standardParameters);
        if (this.isOverwriteMode()) {
            commandLineList.add("--whole-file");
        } else {
            commandLineList.add("--append");
        }
        if (this.sshExecutable != null && destinationHost != null) {
            commandLineList.add("--rsh");
            commandLineList.add(RsyncCopier.getSshExecutableArgument(this.sshExecutable));
        }
        if (this.additionalCmdLineFlags != null) {
            commandLineList.addAll(this.additionalCmdLineFlags);
        }
        commandLineList.add(RsyncCopier.buildPath(sourceHost, sourcePath, false));
        commandLineList.add(RsyncCopier.buildPath(destinationHost, destinationDirectory, true));
        return commandLineList;
    }

    private static final String getSshExecutableArgument(String sshExecutable) {
        if (OSUtilities.isWindows()) {
            return String.valueOf(RsyncCopier.toUnix(sshExecutable)) + " -oBatchMode=yes";
        }
        return String.valueOf(sshExecutable) + " -oBatchMode=yes";
    }

    private static String buildPath(String host, File resource, boolean isDirectory) {
        if (host == null) {
            String path = resource.getAbsolutePath();
            if (isDirectory) {
                path = String.valueOf(path) + File.separator;
            }
            return RsyncCopier.toUnix(path);
        }
        String path = resource.getPath();
        if (isDirectory) {
            path = String.valueOf(path) + File.separator;
        }
        return String.valueOf(host) + ":" + RsyncCopier.toUnix(path);
    }

    private static String toUnix(String path) {
        if (!OSUtilities.isWindows()) {
            return path;
        }
        String resultPath = path.replace('\\', '/');
        if (resultPath.charAt(1) == ':') {
            resultPath = "/cygdrive/" + resultPath.charAt(0) + resultPath.substring(2);
        }
        return resultPath;
    }

    private static final Status createStatus(ProcessResult processResult) {
        if (processResult.isTerminated()) {
            return TERMINATED_STATUS;
        }
        if (processResult.isInterruped()) {
            return INTERRUPTED_STATUS;
        }
        if (processResult.isTimedOut()) {
            return TIMEOUT_STATUS;
        }
        int exitValue = processResult.getExitValue();
        StatusFlag flag = RsyncExitValueTranslator.getStatus(exitValue);
        if (StatusFlag.OK.equals((Object)flag)) {
            return Status.OK;
        }
        return new Status(flag, RsyncExitValueTranslator.getMessage(exitValue));
    }
}

