/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem.rsync;

import ch.systemsx.cisd.common.exceptions.StatusFlag;

final class RsyncExitValueTranslator {
    RsyncExitValueTranslator() {
    }

    public static String getMessage(int exitValue) {
        assert (exitValue > 0);
        return String.format("rsync: %s (%d)", RsyncExitValueTranslator.getRawMessage(exitValue), exitValue);
    }

    private static String getRawMessage(int exitValue) {
        if (exitValue < 0) {
            throw new IllegalArgumentException("Exit value must be > 0 but is: " + exitValue);
        }
        switch (exitValue) {
            case 1: {
                return "syntax or usage error";
            }
            case 2: {
                return "protocol incompatibility";
            }
            case 3: {
                return "errors selecting input/output files, dirs";
            }
            case 4: {
                return "requested action not supported";
            }
            case 5: {
                return "error starting client-server protocol";
            }
            case 10: {
                return "error in socket IO";
            }
            case 11: {
                return "error in file IO";
            }
            case 12: {
                return "error in rsync protocol data stream";
            }
            case 13: {
                return "errors with program diagnostics";
            }
            case 14: {
                return "error in IPC code";
            }
            case 20: {
                return "status returned when sent SIGUSR1, SIGINT";
            }
            case 21: {
                return "some error returned by waitpid()";
            }
            case 22: {
                return "error allocating core memory buffers";
            }
            case 23: {
                return "partial transfer";
            }
            case 24: {
                return "file vanished on sender";
            }
            case 25: {
                return "--max-delete stopped deletions";
            }
            case 30: {
                return "timeout in data send/receive";
            }
            case 124: {
                return "remote shell failed";
            }
            case 125: {
                return "remote shell killed";
            }
            case 126: {
                return "command could not be run";
            }
            case 127: {
                return "command not found";
            }
        }
        return "unknown error";
    }

    public static StatusFlag getStatus(int exitValue) {
        if (exitValue < 0) {
            throw new IllegalArgumentException("Negative exit value: " + exitValue);
        }
        switch (exitValue) {
            case 0: {
                return StatusFlag.OK;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 125: {
                return StatusFlag.RETRIABLE_ERROR;
            }
        }
        return StatusFlag.FATAL_ERROR;
    }
}

