/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.converter.Converter;
import ch.systemsx.cisd.common.converter.ConverterPool;
import ch.systemsx.cisd.common.parser.BeanAnalyzer;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.IPropertyModel;
import ch.systemsx.cisd.common.parser.IndexOutOfBoundsException;
import ch.systemsx.cisd.common.parser.MandatoryPropertyMissingException;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.parser.UnmatchedPropertiesException;
import ch.systemsx.cisd.common.utilities.ClassUtils;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParserObjectFactory<E>
implements IParserObjectFactory<E> {
    private final IPropertyMapper propertyMapper;
    private final ConverterPool converterPool;
    private final Class<E> beanClass;
    private final BeanAnalyzer<E> beanAnalyzer;

    protected AbstractParserObjectFactory(Class<E> beanClass, IPropertyMapper propertyMapper) {
        assert (beanClass != null) : "Given bean class can not be null.";
        assert (propertyMapper != null) : "Given property mapper can not be null.";
        this.beanAnalyzer = new BeanAnalyzer<E>(beanClass);
        this.checkPropertyMapper(beanClass, propertyMapper);
        this.propertyMapper = propertyMapper;
        this.converterPool = AbstractParserObjectFactory.createConverterPool();
        this.beanClass = beanClass;
    }

    private static final ConverterPool createConverterPool() {
        return new ConverterPool();
    }

    protected final <T> void registerConverter(Class<T> clazz, Converter<T> converter) {
        if (converter == null) {
            this.converterPool.unregisterConverter(clazz);
        } else {
            this.converterPool.registerConverter(clazz, converter);
        }
    }

    private final <T> T convert(String value, Class<T> type) {
        return this.converterPool.convert(value, type);
    }

    private final IPropertyModel tryGetPropertyModel(String name) {
        if (this.propertyMapper.containsPropertyName(name)) {
            return this.propertyMapper.getPropertyModel(name);
        }
        return null;
    }

    private final void checkPropertyMapper(Class<E> clazz, IPropertyMapper propMapper) throws ParserException {
        Set<String> allPropertyNames = propMapper.getAllPropertyNames();
        LinkedHashSet<String> propertyNames = new LinkedHashSet<String>(allPropertyNames);
        LinkedHashSet<String> missingProperties = new LinkedHashSet<String>();
        Set<String> fieldNames = this.beanAnalyzer.getLabelToWriteMethods().keySet();
        for (String fieldName : fieldNames) {
            String fieldNameInLowerCase = fieldName.toLowerCase();
            if (propertyNames.contains(fieldNameInLowerCase)) {
                propertyNames.remove(fieldNameInLowerCase);
                continue;
            }
            if (!this.beanAnalyzer.isMandatory(fieldName)) continue;
            missingProperties.add(fieldName);
        }
        Set<String> mandatoryPropertyNames = this.beanAnalyzer.getMandatoryProperties();
        if (missingProperties.size() > 0) {
            throw new MandatoryPropertyMissingException(mandatoryPropertyNames, missingProperties);
        }
        if (propertyNames.size() > 0) {
            throw new UnmatchedPropertiesException(mandatoryPropertyNames, this.beanAnalyzer.getOptionalProperties(), propertyNames);
        }
    }

    private final String getPropertyValue(String[] lineTokens, IPropertyModel propertyModel) {
        int column = propertyModel.getColumn();
        if (column >= lineTokens.length) {
            throw new IndexOutOfBoundsException(column, lineTokens);
        }
        return lineTokens[column];
    }

    @Override
    public E createObject(String[] lineTokens) throws ParserException {
        E object = ClassUtils.createInstance(this.beanClass);
        for (Map.Entry<String, Method> entry : this.beanAnalyzer.getLabelToWriteMethods().entrySet()) {
            Method writeMethod = entry.getValue();
            IPropertyModel propertyModel = this.tryGetPropertyModel(entry.getKey());
            if (propertyModel == null) continue;
            String propertyValue = this.getPropertyValue(lineTokens, propertyModel);
            ClassUtils.invokeMethod(writeMethod, object, this.convert(propertyValue, writeMethod.getParameterTypes()[0]));
        }
        return object;
    }
}

