/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.parser.ColumnSizeMismatchException;
import ch.systemsx.cisd.common.parser.DefaultLineTokenizer;
import ch.systemsx.cisd.common.parser.ILineTokenizer;
import ch.systemsx.cisd.common.parser.IParser;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.Line;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.parser.ParsingException;
import ch.systemsx.cisd.common.parser.filter.ILineFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultParser<E>
implements IParser<E> {
    private final ILineTokenizer lineTokenizer;
    private IParserObjectFactory<E> factory;

    public DefaultParser() {
        this(new DefaultLineTokenizer());
    }

    public DefaultParser(ILineTokenizer lineTokenizer) {
        this.lineTokenizer = lineTokenizer;
    }

    protected E createObject(String[] tokens) throws ParserException {
        return this.factory.createObject(tokens);
    }

    private final String[] parseLine(int lineNumber, String line) {
        return this.lineTokenizer.tokenize(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<E> parse(Iterator<Line> lineIterator, ILineFilter lineFilter, int headerLength) throws ParsingException {
        ArrayList<Object> elements = new ArrayList<Object>();
        ILineTokenizer iLineTokenizer = this.lineTokenizer;
        synchronized (iLineTokenizer) {
            this.lineTokenizer.init();
            while (lineIterator.hasNext()) {
                int number;
                Line line = lineIterator.next();
                String nextLine = line.getText();
                if (!lineFilter.acceptLine(nextLine, number = line.getNumber())) continue;
                String[] tokens = this.parseLine(number, nextLine);
                Object object = null;
                try {
                    if (tokens.length != headerLength) {
                        throw new ColumnSizeMismatchException(tokens, number, headerLength);
                    }
                    object = this.createObject(tokens);
                }
                catch (ParserException parserException) {
                    throw new ParsingException(parserException, tokens, number);
                }
                catch (ParsingException parsingException) {
                    throw parsingException;
                }
                catch (RuntimeException runtimeException) {
                    throw new ParsingException(runtimeException, tokens, number);
                }
                elements.add(object);
            }
            this.lineTokenizer.destroy();
            return elements;
        }
    }

    @Override
    public final void setObjectFactory(IParserObjectFactory<E> factory) {
        this.factory = factory;
    }
}

