/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static final List<Method> getAnnotatedMethodList(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return AnnotationUtils.getAnnotatedMethodList(clazz, annotationClass, null);
    }

    private static final List<Method> getAnnotatedMethodList(Class<?> clazz, Class<? extends Annotation> annotationClass, List<Method> methods) {
        assert (clazz != null) : "Unspecified class.";
        assert (annotationClass != null) : "Unspecified annotation class.";
        List<Method> list = methods;
        if (list == null) {
            list = new ArrayList<Method>();
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getAnnotation(annotationClass) != null) {
                list.add(method);
            }
            ++n2;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            return AnnotationUtils.getAnnotatedMethodList(superclass, annotationClass, list);
        }
        return list;
    }

    public static final List<Field> getAnnotatedFieldList(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return AnnotationUtils.getAnnotatedFieldList(clazz, annotationClass, null);
    }

    private static final List<Field> getAnnotatedFieldList(Class<?> clazz, Class<? extends Annotation> annotationClass, List<Field> fields) {
        assert (clazz != null) : "Unspecified class.";
        assert (annotationClass != null) : "Unspecified annotation class.";
        List<Field> list = fields;
        if (list == null) {
            list = new ArrayList<Field>();
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getAnnotation(annotationClass) != null) {
                list.add(field);
            }
            ++n2;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            return AnnotationUtils.getAnnotatedFieldList(superclass, annotationClass, list);
        }
        return list;
    }
}

