/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.TimingParameters;
import ch.systemsx.cisd.common.exceptions.StopException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.CallableExecutor;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.utilities.IFileImmutableCopier;
import ch.systemsx.cisd.common.utilities.OSUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HardLinkMaker
implements IFileImmutableCopier {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, HardLinkMaker.class);
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, HardLinkMaker.class);
    private static final String HARD_LINK_EXEC = "ln";
    private final String linkExecPath;
    private final TimingParameters timingParameters;

    public static final IFileImmutableCopier tryCreate(TimingParameters timingParameters) {
        File lnExec = OSUtilities.findExecutable(HARD_LINK_EXEC);
        if (lnExec == null) {
            return null;
        }
        return HardLinkMaker.create(lnExec, timingParameters);
    }

    public static final IFileImmutableCopier tryCreate() {
        File lnExec = OSUtilities.findExecutable(HARD_LINK_EXEC);
        if (lnExec == null) {
            return null;
        }
        return HardLinkMaker.create(lnExec);
    }

    public static final IFileImmutableCopier create(File lnExec, TimingParameters timingParameters) {
        return new HardLinkMaker(lnExec.getAbsolutePath(), timingParameters);
    }

    public static final IFileImmutableCopier create(File lnExec) {
        return new HardLinkMaker(lnExec.getAbsolutePath(), TimingParameters.getDefaultParameters());
    }

    private HardLinkMaker(String linkExecPath, TimingParameters timingParameters) {
        this.linkExecPath = linkExecPath;
        this.timingParameters = timingParameters;
    }

    @Override
    public boolean copyFileImmutably(final File source, File destinationDirectory, String nameOrNull) {
        assert (source.isFile()) : String.format("Given file '%s' must be a file and is not.", source);
        final File destFile = new File(destinationDirectory, nameOrNull == null ? source.getName() : nameOrNull);
        final List<String> cmd = this.createLnCmdLine(source, destFile);
        Callable<Boolean> processTask = new Callable<Boolean>(){

            @Override
            public final Boolean call() {
                boolean result = ProcessExecutionHelper.runAndLog(cmd, operationLog, machineLog, HardLinkMaker.this.timingParameters.getTimeoutMillis());
                if (!result && destFile.exists() && HardLinkMaker.checkIfIdenticalContent(source, destFile)) {
                    machineLog.warn("Link creator reported failure, but the exact copy of the file '" + source.getPath() + "' seems to exist in '" + destFile.getPath() + "'. Error will be ignored.");
                    result = true;
                }
                return result;
            }
        };
        boolean ok = HardLinkMaker.runRepeatableProcess(processTask, this.timingParameters.getMaxRetriesOnFailure(), this.timingParameters.getIntervalToWaitAfterFailureMillis());
        return ok;
    }

    private static boolean checkIfIdenticalContent(File file1, File file2) {
        StopException.check();
        try {
            return FileUtils.contentEquals((File)file1, (File)file2);
        }
        catch (IOException e) {
            machineLog.warn("Error when comparing the content of a file and its link: " + e.getMessage());
            return false;
        }
    }

    private final List<String> createLnCmdLine(File srcFile, File destFile) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add(this.linkExecPath);
        tokens.add(srcFile.getAbsolutePath());
        tokens.add(destFile.getAbsolutePath());
        return tokens;
    }

    private static boolean runRepeatableProcess(Callable<Boolean> task, int maxRetryOnFailure, long millisToSleepOnFailure) {
        return new CallableExecutor(maxRetryOnFailure, millisToSleepOnFailure).executeCallable(task);
    }
}

