/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.TimingParameters;
import ch.systemsx.cisd.common.concurrent.ConcurrencyUtilities;
import ch.systemsx.cisd.common.concurrent.InactivityMonitor;
import ch.systemsx.cisd.common.filesystem.rsync.RsyncCopier;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.IDirectoryImmutableCopier;
import ch.systemsx.cisd.common.utilities.OSUtilities;
import ch.systemsx.cisd.common.utilities.RemoteDirectoryCopyActivitySensor;
import java.io.File;
import org.apache.log4j.Logger;

public class RsyncBasedRecursiveHardLinkMaker
implements IDirectoryImmutableCopier {
    private static final String RSYNC_EXEC = "rsync";
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, RsyncBasedRecursiveHardLinkMaker.class);
    private static final int DEFAULT_MAX_ERRORS_TO_IGNORE = 3;
    private final TimingParameters timingParameters;
    private final int maxErrorsToIgnore;
    private final RsyncCopier rsyncCopier;

    public RsyncBasedRecursiveHardLinkMaker() {
        this(null, TimingParameters.getDefaultParameters(), 3);
    }

    public RsyncBasedRecursiveHardLinkMaker(File rsyncExecutableOrNull) {
        this(rsyncExecutableOrNull, TimingParameters.getDefaultParameters(), 3);
    }

    public RsyncBasedRecursiveHardLinkMaker(File rsyncExecutableOrNull, TimingParameters timingParameters, int maxErrorsToIgnore) {
        this.rsyncCopier = rsyncExecutableOrNull == null ? new RsyncCopier(OSUtilities.findExecutable(RSYNC_EXEC)) : new RsyncCopier(rsyncExecutableOrNull);
        this.timingParameters = timingParameters;
        this.maxErrorsToIgnore = maxErrorsToIgnore;
    }

    public boolean copyDirectoryImmutably(File sourceDirectory, File destinationDirectory, String targetNameOrNull) {
        boolean ok;
        File target = new File(destinationDirectory, targetNameOrNull == null ? sourceDirectory.getName() : targetNameOrNull);
        InactivityMonitor.IInactivityObserver observer = new InactivityMonitor.IInactivityObserver(){

            public void update(long inactiveSinceMillis, String descriptionOfInactivity) {
                machineLog.error(String.valueOf(descriptionOfInactivity) + ", terminating rsync");
                RsyncBasedRecursiveHardLinkMaker.this.rsyncCopier.terminate();
            }
        };
        int counter = 0;
        while (!(ok = this.createHardLinks(sourceDirectory, destinationDirectory, targetNameOrNull, target, observer)) && counter++ <= this.timingParameters.getMaxRetriesOnFailure()) {
            if (ok) continue;
            ConcurrencyUtilities.sleep(this.timingParameters.getIntervalToWaitAfterFailureMillis());
        }
        return ok;
    }

    private boolean createHardLinks(File sourceDirectory, File destinationDirectory, String targetNameOrNull, File target, InactivityMonitor.IInactivityObserver observer) {
        InactivityMonitor monitor = new InactivityMonitor(new RemoteDirectoryCopyActivitySensor(target, this.maxErrorsToIgnore), observer, this.timingParameters.getTimeoutMillis(), true);
        boolean result = this.rsyncCopier.copyDirectoryImmutably(sourceDirectory, destinationDirectory, targetNameOrNull);
        monitor.stop();
        return result;
    }

    public static interface ILastChangedChecker {
        public long lastChangedRelative(File var1, long var2);
    }
}

