/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.utilities.ExtendedProperties;
import ch.systemsx.cisd.common.utilities.PropertyUtils;
import ch.systemsx.cisd.etlserver.IStorageProcessor;
import java.io.File;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;

public abstract class AbstractStorageProcessor
implements IStorageProcessor {
    static final String STOREROOT_DIR_KEY = "storeroot-dir";
    protected final Properties properties;
    protected final String storeRootDir;

    protected AbstractStorageProcessor(Properties globalProperties) {
        Properties gProps = globalProperties == null ? new Properties() : globalProperties;
        this.storeRootDir = AbstractStorageProcessor.getStoreRootDir(gProps);
        this.properties = ExtendedProperties.getSubset(gProps, "storage-processor.", true);
    }

    private static final String getStoreRootDir(Properties globalProperties) {
        assert (globalProperties != null) : "Properties are not null at this point.";
        String property = PropertyUtils.getMandatoryProperty(globalProperties, STOREROOT_DIR_KEY);
        return FilenameUtils.normalize((String)new File(property).getAbsolutePath());
    }

    protected final String getMandatoryProperty(String propertyKey) {
        return PropertyUtils.getMandatoryProperty(this.properties, propertyKey);
    }

    protected static final void checkParameters(File incomingDataSetPath, File targetPath) {
        assert (incomingDataSetPath != null) : "Given incoming data set path can not be null.";
        assert (targetPath != null) : "Given target path can not be null.";
    }

    public final File getStoreRootDirectory() {
        File storeRoot = new File(this.storeRootDir);
        return storeRoot;
    }
}

