/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.bds.hcs.Channel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChannelSetHelper {
    private final SortedSet<Integer> wavelengths = new TreeSet<Integer>();
    private Set<Channel> channels;
    private boolean locked = false;
    private Map<Integer, Channel> channelsByWavelength;

    public final void addWavelength(int wavelength) {
        assert (!this.locked) : "You can no longer change the state of this class.";
        this.wavelengths.add(wavelength);
    }

    public final Set<Channel> getChannelSet() {
        this.locked = true;
        if (this.channels == null) {
            TreeSet<Channel> set = new TreeSet<Channel>();
            Iterator iter = this.wavelengths.iterator();
            int i = 0;
            while (iter.hasNext()) {
                set.add(new Channel(i + 1, (Integer)iter.next()));
                ++i;
            }
            this.channels = Collections.unmodifiableSet(set);
        }
        return this.channels;
    }

    public final Channel getChannelForWavelength(int wavelength) {
        this.locked = true;
        if (this.channelsByWavelength == null) {
            HashMap<Integer, Channel> map = new HashMap<Integer, Channel>();
            for (Channel channel : this.getChannelSet()) {
                map.put(channel.getWavelength(), channel);
            }
            this.channelsByWavelength = Collections.unmodifiableMap(map);
        }
        Channel channel = this.channelsByWavelength.get(wavelength);
        assert (channel != null) : String.format("Given wavelength %d can not be found.", wavelength);
        return channel;
    }
}

