/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.PropertyUtils;
import ch.systemsx.cisd.etlserver.DataSetInformation;
import ch.systemsx.cisd.etlserver.DataSetNameEntitiesProvider;
import ch.systemsx.cisd.etlserver.DefaultDataSetInfoExtractor;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import java.io.File;
import java.util.Properties;

public class DataSetInfoExtractorForPlatesOnDemand
extends DefaultDataSetInfoExtractor {
    static final String INDEX_OF_PROJECT_CODE = "index-of-project-code";
    private static final int DEFAULT_INDEX_OF_PROJECT_CODE = -3;
    static final String INDEX_OF_EXPERIMENT_CODE = "index-of-experiment-code";
    private static final int DEFAULT_INDEX_OF_EXPERIMENT_CODE = -2;
    private final int indexOfProjectCode;
    private final int indexOfExperimentCode;

    public DataSetInfoExtractorForPlatesOnDemand(Properties globalProperties) {
        super(globalProperties);
        this.indexOfProjectCode = PropertyUtils.getInt(this.properties, INDEX_OF_PROJECT_CODE, -3);
        this.indexOfExperimentCode = PropertyUtils.getInt(this.properties, INDEX_OF_EXPERIMENT_CODE, -2);
    }

    public DataSetInformation getDataSetInformation(File incomingDataSetPath) throws UserFailureException, EnvironmentFailureException {
        DataSetInformation dataSetInformation = super.getDataSetInformation(incomingDataSetPath);
        ExperimentIdentifier experimentIdentifier = new ExperimentIdentifier();
        DataSetNameEntitiesProvider entitiesProvider = new DataSetNameEntitiesProvider(incomingDataSetPath, this.entitySeparator);
        experimentIdentifier.setProjectCode(entitiesProvider.getEntity(this.indexOfProjectCode));
        experimentIdentifier.setExperimentCode(entitiesProvider.getEntity(this.indexOfExperimentCode));
        dataSetInformation.setExperimentIdentifier(experimentIdentifier);
        return dataSetInformation;
    }
}

