/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import java.util.Properties;
import org.apache.log4j.Logger;

final class DataSetMover {
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, DataSetMover.class);
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSetMover.class);

    DataSetMover(Properties propertiesOrNull) {
    }

    final boolean moveDataSetAndLog(File incomingDataSetFile, File targetFile) {
        String absoluteTargetPath = targetFile.getAbsolutePath();
        if (targetFile.exists()) {
            notificationLog.error(String.format("Target path '%s' of incoming data set already exists. Won't overwrite it.", absoluteTargetPath));
            return false;
        }
        boolean movedOK = FileOperations.getMonitoredInstanceForCurrentThread().rename(incomingDataSetFile, targetFile);
        if (movedOK) {
            if (operationLog.isInfoEnabled()) {
                String entity = incomingDataSetFile.isDirectory() ? "directory" : "file";
                String name = incomingDataSetFile.getName();
                String parent = incomingDataSetFile.getParent();
                String path = targetFile.getParent();
                operationLog.info(String.format("Moving %s '%s' from '%s' to '%s'.", entity, name, parent, path));
            }
        } else {
            notificationLog.error(String.format("Moving '%s' to '%s' failed, giving up.", incomingDataSetFile.getAbsolutePath(), absoluteTargetPath));
        }
        return movedOK;
    }
}

