/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.PropertyUtils;
import ch.systemsx.cisd.etlserver.AbstractDataSetInfoExtractor;
import ch.systemsx.cisd.etlserver.DataSetInformation;
import ch.systemsx.cisd.etlserver.DataSetNameEntitiesProvider;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class DefaultDataSetInfoExtractor
extends AbstractDataSetInfoExtractor {
    static final String INDEX_OF_SAMPLE_CODE = "index-of-sample-code";
    static final String INDEX_OF_PARENT_DATA_SET_CODE = "index-of-parent-data-set-code";
    private static final int DEFAULT_INDEX_OF_SAMPLE_CODE = -1;
    static final String INDEX_OF_DATA_PRODUCER_CODE = "index-of-data-producer-code";
    static final String INDEX_OF_DATA_PRODUCTION_DATE = "index-of-data-production-date";
    static final String DATA_PRODUCTION_DATE_FORMAT = "data-production-date-format";
    private static final String DEFAULT_DATA_PRODUCTION_DATE_FORMAT = "yyyyMMddHHmmss";
    private final int indexOfSampleCode;
    private final boolean noParentDataSetCode;
    private final int indexOfParentDataSetCode;
    private final boolean noDataProducerCode;
    private final int indexOfDataProducerCode;
    private final boolean noDataProductionDate;
    private final int indexOfDataProductionDate;
    private final SimpleDateFormat dateFormat;

    public DefaultDataSetInfoExtractor(Properties globalProperties) {
        super(globalProperties);
        this.indexOfSampleCode = PropertyUtils.getInt(this.properties, INDEX_OF_SAMPLE_CODE, -1);
        String indexAsString = this.properties.getProperty(INDEX_OF_PARENT_DATA_SET_CODE);
        this.noParentDataSetCode = indexAsString == null;
        this.indexOfParentDataSetCode = PropertyUtils.getInt(this.properties, INDEX_OF_PARENT_DATA_SET_CODE, 0);
        indexAsString = this.properties.getProperty(INDEX_OF_DATA_PRODUCER_CODE);
        this.noDataProducerCode = indexAsString == null;
        this.indexOfDataProducerCode = PropertyUtils.getInt(this.properties, INDEX_OF_DATA_PRODUCER_CODE, 0);
        indexAsString = this.properties.getProperty(INDEX_OF_DATA_PRODUCTION_DATE);
        this.noDataProductionDate = indexAsString == null;
        this.indexOfDataProductionDate = PropertyUtils.getInt(this.properties, INDEX_OF_DATA_PRODUCTION_DATE, 0);
        this.dateFormat = new SimpleDateFormat(this.properties.getProperty(DATA_PRODUCTION_DATE_FORMAT, DEFAULT_DATA_PRODUCTION_DATE_FORMAT));
    }

    public DataSetInformation getDataSetInformation(File incomingDataSetPath) throws EnvironmentFailureException, UserFailureException {
        assert (incomingDataSetPath != null) : "Incoming data set path can not be null.";
        DataSetNameEntitiesProvider entitiesProvider = new DataSetNameEntitiesProvider(incomingDataSetPath, this.entitySeparator);
        DataSetInformation dataSetInformation = new DataSetInformation();
        dataSetInformation.setSampleCode(entitiesProvider.getEntity(this.indexOfSampleCode));
        dataSetInformation.setParentDataSetCode(this.tryGetParentDataSetCode(entitiesProvider));
        dataSetInformation.setProducerCode(this.tryGetDataProducerCode(entitiesProvider));
        dataSetInformation.setProductionDate(this.tryGetDataProductionDate(entitiesProvider));
        return dataSetInformation;
    }

    private String tryGetParentDataSetCode(DataSetNameEntitiesProvider dataSetNameEntitiesProvider) {
        if (this.noParentDataSetCode) {
            return null;
        }
        return dataSetNameEntitiesProvider.getEntity(this.indexOfParentDataSetCode);
    }

    private String tryGetDataProducerCode(DataSetNameEntitiesProvider dataSetNameEntitiesProvider) {
        if (this.noDataProducerCode) {
            return null;
        }
        return dataSetNameEntitiesProvider.getEntity(this.indexOfDataProducerCode);
    }

    private Date tryGetDataProductionDate(DataSetNameEntitiesProvider dataSetNameEntitiesProvider) {
        if (this.noDataProductionDate) {
            return null;
        }
        String dateString = dataSetNameEntitiesProvider.getEntity(this.indexOfDataProductionDate);
        try {
            return this.dateFormat.parse(dateString);
        }
        catch (ParseException parseException) {
            throw new UserFailureException("Could not parse data production date '" + dateString + "' because it violates the following format: " + this.dateFormat.toPattern());
        }
    }
}

