/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.TimingParameters;
import ch.systemsx.cisd.common.utilities.FastRecursiveHardLinkMaker;
import ch.systemsx.cisd.common.utilities.IImmutableCopier;
import ch.systemsx.cisd.etlserver.FileBasedFile;
import ch.systemsx.cisd.etlserver.IFile;
import ch.systemsx.cisd.etlserver.IFileFactory;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

public class FileBasedFileFactory
implements IFileFactory {
    private final IImmutableCopier hardLinkCopierOrNull;

    public FileBasedFileFactory(boolean hardLinkInsteadOfCopy) {
        this(hardLinkInsteadOfCopy, TimingParameters.getDefaultParameters());
    }

    public FileBasedFileFactory(boolean hardLinkInsteadOfCopy, TimingParameters timingParameters) {
        this.hardLinkCopierOrNull = FileBasedFileFactory.tryGetHardLinkCopier(hardLinkInsteadOfCopy, timingParameters);
    }

    private static IImmutableCopier tryGetHardLinkCopier(boolean hardLinkInsteadOfCopy, TimingParameters timingParameters) {
        if (hardLinkInsteadOfCopy) {
            return FastRecursiveHardLinkMaker.tryCreate(timingParameters);
        }
        return null;
    }

    private final IFile wrap(File file) {
        return new FileBasedFile(file, this.hardLinkCopierOrNull);
    }

    public final IFile create(String path) {
        assert (path != null) : "Unspecified path.";
        File file = new File(path);
        return this.wrap(file);
    }

    public final IFile create(IFile baseDir, String relativePath) {
        assert (baseDir != null) : "Unspecified base directory.";
        assert (relativePath != null) : "Unspecified relative pate";
        assert (FilenameUtils.getPrefixLength((String)relativePath) == 0) : String.format("Given relative path '%s' is not relative.", relativePath);
        return this.wrap(new File(baseDir.getAbsolutePath(), relativePath));
    }
}

