/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.utilities.ExtendedProperties;
import ch.systemsx.cisd.etlserver.IProcedureAndDataTypeExtractor;
import ch.systemsx.cisd.lims.base.FileFormatType;
import ch.systemsx.cisd.lims.base.LocatorType;
import ch.systemsx.cisd.lims.base.ObservableType;
import ch.systemsx.cisd.lims.base.ObservableTypeCode;
import ch.systemsx.cisd.lims.base.ProcedureType;
import ch.systemsx.cisd.lims.base.ProcedureTypeCode;
import java.io.File;
import java.util.Properties;

public class SimpleTypeExtractor
implements IProcedureAndDataTypeExtractor {
    public static final String FILE_FORMAT_TYPE_KEY = "file-format-type";
    public static final String LOCATOR_TYPE_KEY = "locator-type";
    public static final String OBSERVABLE_TYPE_KEY = "observable-type";
    public static final String PROCEDURE_TYPE_KEY = "procedure-type";
    private FileFormatType fileFormatType;
    private LocatorType locatorType;
    private ObservableType observableType;
    private ProcedureType procedureType;

    public SimpleTypeExtractor(Properties globalProperties) {
        ExtendedProperties properties = ExtendedProperties.getSubset(globalProperties, "type-extractor.", true);
        String code = ((Properties)properties).getProperty(FILE_FORMAT_TYPE_KEY, "TIFF");
        this.fileFormatType = new FileFormatType(code);
        code = ((Properties)properties).getProperty(LOCATOR_TYPE_KEY, "RELATIVE_LOCATION");
        this.locatorType = new LocatorType(code);
        code = ((Properties)properties).getProperty(OBSERVABLE_TYPE_KEY, ObservableTypeCode.HCS_IMAGE.getCode());
        this.observableType = new ObservableType(code);
        code = ((Properties)properties).getProperty(PROCEDURE_TYPE_KEY, ProcedureTypeCode.DATA_ACQUISITION.getCode());
        this.procedureType = new ProcedureType(code);
    }

    public final FileFormatType getFileFormatType(File incomingDataSetPath) {
        return this.fileFormatType;
    }

    public final LocatorType getLocatorType(File incomingDataSetPath) {
        return this.locatorType;
    }

    public final ObservableType getObservableType(File incomingDataSetPath) {
        return this.observableType;
    }

    public final ProcedureType getProcedureType(File incomingDataSetPath) {
        return this.procedureType;
    }
}

