/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.etlserver.IETLServerPlugin;
import ch.systemsx.cisd.etlserver.PropertiesBasedETLServerPlugin;
import java.io.File;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ThreadParameters {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ThreadParameters.class);
    private static final String INCOMING_DIR = "incoming-dir";
    private final File incomingDataDirectory;
    private final IETLServerPlugin plugin;
    private final String threadName;

    public ThreadParameters(Properties threadProperties, String threadName) {
        this.incomingDataDirectory = ThreadParameters.extractIncomingDataDir(threadProperties);
        this.plugin = new PropertiesBasedETLServerPlugin(threadProperties);
        this.threadName = threadName;
    }

    void check() {
        if (!this.incomingDataDirectory.isDirectory()) {
            throw new ConfigurationFailureException("Incoming directory '" + this.incomingDataDirectory + "' is not a directory.");
        }
    }

    private static File extractIncomingDataDir(Properties threadProperties) {
        String incomingDir = threadProperties.getProperty(INCOMING_DIR);
        if (StringUtils.isNotBlank((String)incomingDir)) {
            return FileUtilities.normalizeFile(new File(incomingDir));
        }
        throw new ConfigurationFailureException("No 'incoming-dir' defined.");
    }

    public File getIncomingDataDirectory() {
        return this.incomingDataDirectory;
    }

    public IETLServerPlugin getPlugin() {
        return this.plugin;
    }

    public void log() {
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("[%s] Code extractor: '%s'", this.threadName, this.plugin.getDataSetInfoExtractor().getClass().getName()));
            operationLog.info(String.format("[%s] Type extractor: '%s'", this.threadName, this.plugin.getTypeExtractor().getClass().getName()));
            operationLog.info(String.format("[%s] Incoming data directory: '%s'.", this.threadName, this.getIncomingDataDirectory().getAbsolutePath()));
        }
    }

    public String getThreadName() {
        return this.threadName;
    }
}

