/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.HighLevelException;
import ch.systemsx.cisd.common.exceptions.StopException;
import ch.systemsx.cisd.common.filesystem.QueueingPathRemoverService;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.MailClient;
import ch.systemsx.cisd.common.types.BooleanOrUnknown;
import ch.systemsx.cisd.common.utilities.BeanUtils;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.common.utilities.IPathHandler;
import ch.systemsx.cisd.common.utilities.ISelfTestable;
import ch.systemsx.cisd.etlserver.DataSetInformation;
import ch.systemsx.cisd.etlserver.DataStoreStrategyKey;
import ch.systemsx.cisd.etlserver.DataStrategyStore;
import ch.systemsx.cisd.etlserver.IDataSetInfoExtractor;
import ch.systemsx.cisd.etlserver.IDataStoreStrategy;
import ch.systemsx.cisd.etlserver.IDataStrategyStore;
import ch.systemsx.cisd.etlserver.IETLServerPlugin;
import ch.systemsx.cisd.etlserver.IEncapsulatedLimsService;
import ch.systemsx.cisd.etlserver.IProcedureAndDataTypeExtractor;
import ch.systemsx.cisd.etlserver.IProcessor;
import ch.systemsx.cisd.etlserver.IProcessorFactory;
import ch.systemsx.cisd.etlserver.IStorageProcessor;
import ch.systemsx.cisd.etlserver.IStoreRootDirectoryProvider;
import ch.systemsx.cisd.etlserver.NamedDataStrategy;
import ch.systemsx.cisd.etlserver.Parameters;
import ch.systemsx.cisd.lims.base.BaseExperiment;
import ch.systemsx.cisd.lims.base.ExternalData;
import ch.systemsx.cisd.lims.base.ExtractableData;
import ch.systemsx.cisd.lims.base.ObservableType;
import ch.systemsx.cisd.lims.base.ProcessingInstruction;
import ch.systemsx.cisd.lims.base.util.StorageFormat;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransferredDataSetHandler
implements IPathHandler,
ISelfTestable {
    static final String TARGET_NOT_RELATIVE_TO_STORE_ROOT = "Target path '%s' is not relative to store root directory '%s'.";
    static final String SUCCESSFULLY_REGISTERED_TEMPLATE = "Successfully registered data set '%s' for sample '%s', observable type '%s', experiment '%s' with openBIS service.";
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, TransferredDataSetHandler.class);
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, TransferredDataSetHandler.class);
    private static final NamedDataStrategy ERROR_DATA_STRATEGY = new NamedDataStrategy(DataStoreStrategyKey.ERROR);
    private final IStoreRootDirectoryProvider storeRootDirectoryProvider;
    private final IETLServerPlugin plugin;
    private final IEncapsulatedLimsService limsService;
    private final IDataStrategyStore dataStrategyStore;
    private final IDataSetInfoExtractor dataSetInfoExtractor;
    private final Lock registrationLock;
    private Map<String, IProcessorFactory> processorFactories = Collections.emptyMap();
    private IProcedureAndDataTypeExtractor typeExtractor;
    private IStorageProcessor storageProcessor;
    private final IMailClient mailClient;
    private final String instanceCode;
    private final boolean sendNotificationOnSuccessfulRegistration;
    private boolean stopped = false;

    public TransferredDataSetHandler(String instanceCode, IETLServerPlugin plugin, IEncapsulatedLimsService limsService, Parameters parameters) {
        this(instanceCode, plugin.getStorageProcessor(), plugin, limsService, new MailClient(parameters.getMailProperties()), parameters.isSendNotificationOnSuccessFullRegistration());
    }

    TransferredDataSetHandler(String instanceCode, IStoreRootDirectoryProvider storeRootDirectoryProvider, IETLServerPlugin plugin, IEncapsulatedLimsService limsService, IMailClient mailClient, boolean sendNotificationOnSuccessfulRegistration) {
        assert (instanceCode != null) : "Unspecified instance code";
        assert (storeRootDirectoryProvider != null) : "Given store root directory provider can not be null.";
        assert (plugin != null) : "IETLServerPlugin implementation can not be null.";
        assert (limsService != null) : "IEncapsulatedLimsService implementation can not be null.";
        assert (mailClient != null) : "IMailClient implementation can not be null.";
        this.instanceCode = instanceCode;
        this.storeRootDirectoryProvider = storeRootDirectoryProvider;
        this.plugin = plugin;
        this.dataSetInfoExtractor = plugin.getDataSetInfoExtractor();
        this.typeExtractor = plugin.getTypeExtractor();
        this.storageProcessor = plugin.getStorageProcessor();
        this.limsService = limsService;
        this.mailClient = mailClient;
        this.sendNotificationOnSuccessfulRegistration = sendNotificationOnSuccessfulRegistration;
        this.dataStrategyStore = new DataStrategyStore(this.limsService, mailClient);
        this.registrationLock = new ReentrantLock();
    }

    public final void setProcessorFactories(Map<String, IProcessorFactory> processorFactories) {
        assert (processorFactories != null) : "Unspecified processor factory map.";
        this.processorFactories = processorFactories;
    }

    public Lock getRegistrationLock() {
        return this.registrationLock;
    }

    @Override
    public final void handle(File isFinishedFile) {
        if (this.stopped) {
            return;
        }
        RegistrationHelper registrationHelper = new RegistrationHelper(isFinishedFile);
        registrationHelper.prepare();
        if (registrationHelper.hasDataSetBeenIdentified()) {
            registrationHelper.registerDataSet();
        } else {
            registrationHelper.moveDataSet();
        }
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public final void check() throws ConfigurationFailureException {
        String errorMessage;
        File storeRootDirectory = this.storeRootDirectoryProvider.getStoreRootDirectory();
        storeRootDirectory.mkdirs();
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("Checking store root directory '" + storeRootDirectory.getAbsolutePath() + "'.");
        }
        if ((errorMessage = FileUtilities.checkDirectoryFullyAccessible(storeRootDirectory, "store root")) != null) {
            throw new ConfigurationFailureException(errorMessage);
        }
    }

    private final class RegistrationHelper {
        private final File isFinishedFile;
        private File incomingDataSetFile;
        private DataSetInformation dataSetInformation;
        private IDataStoreStrategy dataStoreStrategy;
        private File baseDirectory;
        private File targetFile;
        private File storeRoot;
        private ObservableType observableType;

        RegistrationHelper(File isFinishedFile) {
            assert (isFinishedFile != null) : "Unspecified is-finished file.";
            String name = isFinishedFile.getName();
            assert (name.startsWith(".MARKER_is_finished_")) : "A finished file must starts with '.MARKER_is_finished_'.";
            this.isFinishedFile = isFinishedFile;
        }

        final void prepare() {
            this.incomingDataSetFile = this.getIncomingDataSetPath(this.isFinishedFile);
            this.dataSetInformation = this.extractDataSetInformation(this.incomingDataSetFile);
            if (this.dataSetInformation.getDataSetCode() == null) {
                this.dataSetInformation.setDataSetCode(TransferredDataSetHandler.this.limsService.createDataSetCode());
            }
            this.dataStoreStrategy = TransferredDataSetHandler.this.dataStrategyStore.getDataStoreStrategy(this.dataSetInformation, this.incomingDataSetFile);
            this.observableType = TransferredDataSetHandler.this.typeExtractor.getObservableType(this.incomingDataSetFile);
            this.storeRoot = TransferredDataSetHandler.this.storageProcessor.getStoreRootDirectory();
            this.baseDirectory = this.createBaseDirectory(this.dataStoreStrategy, this.storeRoot, this.dataSetInformation);
            this.targetFile = this.dataStoreStrategy.getTargetPath(this.baseDirectory, this.incomingDataSetFile);
        }

        final boolean hasDataSetBeenIdentified() {
            return this.dataStoreStrategy.getKey() == DataStoreStrategyKey.IDENTIFIED;
        }

        final void registerDataSet() {
            BaseExperiment experiment = this.dataSetInformation.getExperiment();
            String procedureTypeCode = TransferredDataSetHandler.this.typeExtractor.getProcedureType(this.incomingDataSetFile).getCode();
            IProcessor processorOrNull = this.tryCreateProcessor(procedureTypeCode);
            try {
                this.registerDataSetAndInitiateProcessing(experiment, procedureTypeCode, processorOrNull);
                this.logAndNotifySuccessfulRegistration(experiment.getRegistrator().getEmail());
                if (this.incomingDataSetFile.exists() && !QueueingPathRemoverService.getInstance().removeRecursively(this.incomingDataSetFile)) {
                    operationLog.error("Cannot delete '" + this.incomingDataSetFile.getAbsolutePath() + "'.");
                }
                this.deleteAndLogIsFinishedFile();
            }
            catch (Throwable throwable) {
                this.rollback(throwable);
            }
        }

        private void rollback(Throwable throwable) throws Error {
            TransferredDataSetHandler transferredDataSetHandler = TransferredDataSetHandler.this;
            transferredDataSetHandler.stopped = transferredDataSetHandler.stopped | throwable instanceof StopException;
            if (TransferredDataSetHandler.this.stopped) {
                Thread.interrupted();
                operationLog.warn(String.format("Requested to stop registration of data set '%s'", this.dataSetInformation));
            } else {
                notificationLog.error(String.format("Registration of data set '%s' failed.", this.dataSetInformation), throwable);
            }
            if (throwable instanceof Error && !(throwable instanceof AssertionError)) {
                throw (Error)throwable;
            }
            TransferredDataSetHandler.this.storageProcessor.unstoreData(this.incomingDataSetFile, this.baseDirectory);
            if (!TransferredDataSetHandler.this.stopped) {
                this.baseDirectory = this.createBaseDirectory(ERROR_DATA_STRATEGY, this.storeRoot, this.dataSetInformation);
                this.targetFile = ERROR_DATA_STRATEGY.getTargetPath(this.baseDirectory, this.incomingDataSetFile);
                boolean moveInCaseOfErrorOk = TransferredDataSetHandler.this.plugin.moveDataSetAndLog(this.incomingDataSetFile, this.targetFile);
                this.writeThrowable(throwable);
                if (moveInCaseOfErrorOk) {
                    this.deleteAndLogIsFinishedFile();
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void registerDataSetAndInitiateProcessing(BaseExperiment experiment, String procedureTypeCode, IProcessor processorOrNull) {
            File markerFile = this.createProcessingMarkerFile();
            try {
                if (operationLog.isInfoEnabled()) {
                    operationLog.info("Start storing data set for sample '" + this.dataSetInformation.getSampleCode() + "'.");
                }
                StopWatch watch = new StopWatch();
                watch.start();
                File dataFile = TransferredDataSetHandler.this.storageProcessor.storeData(experiment, this.dataSetInformation, TransferredDataSetHandler.this.typeExtractor, TransferredDataSetHandler.this.mailClient, this.incomingDataSetFile, this.baseDirectory);
                if (operationLog.isInfoEnabled()) {
                    operationLog.info("Finished storing data set for sample '" + this.dataSetInformation.getSampleCode() + "', took " + watch);
                }
                assert (dataFile != null) : "The folder that contains the stored data should not be null.";
                String relativePath = FileUtilities.getRelativeFile(this.storeRoot, dataFile);
                assert (relativePath != null) : String.format("Target path '%s' is not relative to store root directory '%s'.", dataFile.getAbsolutePath(), this.storeRoot.getAbsolutePath());
                StorageFormat availableFormat = TransferredDataSetHandler.this.storageProcessor.getStorageFormat();
                BooleanOrUnknown isCompleteFlag = this.dataSetInformation.getIsCompleteFlag();
                TransferredDataSetHandler.this.getRegistrationLock().lock();
                try {
                    this.plainRegisterDataSet(relativePath, procedureTypeCode, availableFormat, isCompleteFlag);
                    markerFile.delete();
                    this.deleteAndLogIsFinishedFile();
                    if (processorOrNull == null) {
                        return;
                    }
                    StorageFormat requiredFormat = processorOrNull.getRequiredInputDataFormat();
                    boolean canInitiateProcessing = requiredFormat.equals((Object)availableFormat);
                    if (!canInitiateProcessing && this.availableFormatMayContainRequiredFormat(availableFormat, requiredFormat) && (dataFile = TransferredDataSetHandler.this.storageProcessor.tryGetProprietaryData(dataFile)) != null) {
                        canInitiateProcessing = true;
                    }
                    if (!canInitiateProcessing) {
                        operationLog.error(String.format("Configuration Error: mismatch in data set format for data set '%s' between storage processor and processor (storage processor: %s, processor: %s) -> No processing initiated.", new Object[]{this.dataSetInformation, availableFormat, requiredFormat}));
                        notificationLog.error(String.format("Configuration Error: no processing initiated for data set '%s'", this.dataSetInformation));
                        return;
                    }
                    ProcessingInstruction processingInstructionOrNull = this.tryToGetAppropriateProcessingInstruction(experiment.getProcessingInstructions(), procedureTypeCode);
                    if (processingInstructionOrNull == null) return;
                    try {
                        processorOrNull.initiateProcessing(processingInstructionOrNull, this.dataSetInformation, dataFile);
                        return;
                    }
                    catch (RuntimeException e) {
                        operationLog.error("Exception thrown when initiate processing for data set '" + this.dataSetInformation + "'.", e);
                        notificationLog.error("Couldn't initiate processing a data set for sample '" + this.dataSetInformation.getSampleCode() + "' for some reason. For more details see log of the ETL Server.");
                    }
                    return;
                }
                finally {
                    TransferredDataSetHandler.this.getRegistrationLock().unlock();
                }
            }
            finally {
                markerFile.delete();
            }
        }

        private File createProcessingMarkerFile() {
            File baseParentDirectory = this.baseDirectory.getParentFile();
            String processingDirName = this.baseDirectory.getName();
            File markerFile = new File(baseParentDirectory, ".MARKER_processing_" + processingDirName);
            try {
                markerFile.createNewFile();
            }
            catch (IOException ex) {
                throw EnvironmentFailureException.fromTemplate(ex, "Cannot create marker file '%s'.", markerFile.getPath());
            }
            return markerFile;
        }

        private boolean availableFormatMayContainRequiredFormat(StorageFormat availableFormat, StorageFormat requiredFormat) {
            return StorageFormat.PROPRIETARY.equals((Object)requiredFormat) && StorageFormat.BDS_DIRECTORY.equals((Object)availableFormat);
        }

        final void moveDataSet() {
            boolean ok = TransferredDataSetHandler.this.plugin.moveDataSetAndLog(this.incomingDataSetFile, this.targetFile);
            if (ok) {
                this.deleteAndLogIsFinishedFile();
            }
        }

        private final void plainRegisterDataSet(String relativePath, String procedureTypeCode, StorageFormat storageFormat, BooleanOrUnknown isCompleteFlag) {
            ExternalData data = this.createExternalData(relativePath, storageFormat, isCompleteFlag);
            TransferredDataSetHandler.this.limsService.registerDataSet(this.dataSetInformation, procedureTypeCode, data);
        }

        private void logAndNotifySuccessfulRegistration(String email) {
            String msg = null;
            if (operationLog.isInfoEnabled()) {
                msg = this.getSuccessRegistrationMessage();
                operationLog.info(msg);
            }
            if (TransferredDataSetHandler.this.sendNotificationOnSuccessfulRegistration) {
                if (msg == null) {
                    msg = this.getSuccessRegistrationMessage();
                }
                if (notificationLog.isInfoEnabled()) {
                    notificationLog.info(msg);
                }
                if (!StringUtils.isBlank((String)email)) {
                    TransferredDataSetHandler.this.mailClient.sendMessage(String.format("Success: data set for experiment '%s", this.dataSetInformation.getExperimentIdentifier().getExperimentCode()), msg, email);
                }
            }
        }

        private String getSuccessRegistrationMessage() {
            return String.format(TransferredDataSetHandler.SUCCESSFULLY_REGISTERED_TEMPLATE, this.dataSetInformation.getDataSetCode(), this.dataSetInformation.getSampleCode(), this.observableType.getCode(), this.dataSetInformation.getExperimentIdentifier());
        }

        private final File getIncomingDataSetPath(File isFinishedPath) {
            String errorMsg;
            File incomingDataSetPath = FileUtilities.removePrefixFromFileName(isFinishedPath, ".MARKER_is_finished_");
            if (operationLog.isDebugEnabled()) {
                operationLog.debug(String.format("Getting incoming data set path '%s' from is-finished path '%s'", incomingDataSetPath, isFinishedPath));
            }
            if ((errorMsg = FileUtilities.checkPathFullyAccessible(incomingDataSetPath, "incoming data set")) != null) {
                isFinishedPath.delete();
                throw EnvironmentFailureException.fromTemplate(String.format("Error moving path '%s' from '%s' to '%s': %s", incomingDataSetPath.getName(), incomingDataSetPath.getParent(), TransferredDataSetHandler.this.storeRootDirectoryProvider.getStoreRootDirectory(), errorMsg), new Object[0]);
            }
            return incomingDataSetPath;
        }

        private final DataSetInformation extractDataSetInformation(File incomingDataSetPath) {
            try {
                DataSetInformation dataSetInfo = TransferredDataSetHandler.this.dataSetInfoExtractor.getDataSetInformation(incomingDataSetPath);
                if (dataSetInfo.getSampleCode() == null) {
                    String extractorName = TransferredDataSetHandler.this.dataSetInfoExtractor.getClass().getSimpleName();
                    throw ConfigurationFailureException.fromTemplate("Data Set Information Extractor '%s' extracted no sample code for incoming data set '%s' (extractor contract violation).", extractorName, incomingDataSetPath);
                }
                dataSetInfo.setInstanceCode(TransferredDataSetHandler.this.instanceCode);
                if (operationLog.isDebugEnabled()) {
                    operationLog.debug(String.format("Extracting data set information '%s' from incoming data set path '%s'", dataSetInfo, incomingDataSetPath));
                }
                return dataSetInfo;
            }
            catch (HighLevelException e) {
                throw e;
            }
            catch (RuntimeException ex) {
                throw new EnvironmentFailureException("Error when trying to identify data set '" + incomingDataSetPath.getAbsolutePath() + "'.", ex);
            }
        }

        private final File createBaseDirectory(IDataStoreStrategy strategy, File baseDir, DataSetInformation dataSetInfo) {
            File directory = strategy.getBaseDirectory(baseDir, dataSetInfo, this.observableType);
            directory.mkdirs();
            if (!directory.isDirectory()) {
                throw EnvironmentFailureException.fromTemplate("Creating data set base directory '%s' for data set '%s' failed.", directory.getAbsolutePath(), this.incomingDataSetFile);
            }
            return directory;
        }

        private IProcessor tryCreateProcessor(String procedureTypeCode) {
            IProcessorFactory processorFactory = (IProcessorFactory)TransferredDataSetHandler.this.processorFactories.get(procedureTypeCode);
            if (processorFactory == null) {
                return null;
            }
            return processorFactory.createProcessor();
        }

        private ProcessingInstruction tryToGetAppropriateProcessingInstruction(ProcessingInstruction[] processingInstructions, String procedureTypeCode) {
            if (processingInstructions != null) {
                ProcessingInstruction[] processingInstructionArray = processingInstructions;
                int n = processingInstructions.length;
                int n2 = 0;
                while (n2 < n) {
                    ProcessingInstruction instruction = processingInstructionArray[n2];
                    if (instruction.getProcedureTypeCode().equals(procedureTypeCode)) {
                        return instruction;
                    }
                    ++n2;
                }
            }
            return null;
        }

        private final ExternalData createExternalData(String relativePath, StorageFormat storageFormat, BooleanOrUnknown isCompleteFlag) {
            ExtractableData extractableData = this.dataSetInformation.getExtractableData();
            ExternalData data = BeanUtils.createBean(ExternalData.class, extractableData);
            data.setLocation(relativePath);
            data.setLocatorType(TransferredDataSetHandler.this.typeExtractor.getLocatorType(this.incomingDataSetFile));
            data.setObservableType(TransferredDataSetHandler.this.typeExtractor.getObservableType(this.incomingDataSetFile));
            data.setFileFormatType(TransferredDataSetHandler.this.typeExtractor.getFileFormatType(this.incomingDataSetFile));
            data.setStorageFormat(storageFormat);
            data.setComplete(isCompleteFlag);
            return data;
        }

        private final void writeThrowable(Throwable throwable) {
            block5: {
                String fileName = String.valueOf(this.incomingDataSetFile.getName()) + ".exception";
                File file = new File(this.targetFile.getParentFile(), fileName);
                FileWriter writer = null;
                try {
                    try {
                        writer = new FileWriter(file);
                        throwable.printStackTrace(new PrintWriter(writer));
                    }
                    catch (IOException e) {
                        operationLog.warn(String.format("Could not write out the exception '%s' in file '%s'.", fileName, file.getAbsolutePath()), e);
                        IOUtils.closeQuietly((Writer)writer);
                        break block5;
                    }
                }
                catch (Throwable throwable2) {
                    IOUtils.closeQuietly(writer);
                    throw throwable2;
                }
                IOUtils.closeQuietly((Writer)writer);
            }
        }

        private boolean deleteAndLogIsFinishedFile() {
            if (!this.isFinishedFile.exists()) {
                return false;
            }
            boolean ok = this.isFinishedFile.delete();
            String absolutePath = this.isFinishedFile.getAbsolutePath();
            if (!ok) {
                notificationLog.error(String.format("Removing path '%s' failed.", absolutePath));
            } else if (operationLog.isDebugEnabled()) {
                operationLog.debug(String.format("Following path '%s' has been removed.", absolutePath));
            }
            return ok;
        }
    }
}

