/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.imsb;

import ch.systemsx.cisd.bds.hcs.Channel;
import ch.systemsx.cisd.bds.hcs.Geometry;
import ch.systemsx.cisd.bds.hcs.Location;
import ch.systemsx.cisd.bds.hcs.WellGeometry;
import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.IFile;
import ch.systemsx.cisd.bds.storage.INode;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidExternalDataException;
import ch.systemsx.cisd.common.exceptions.StopException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.ChannelSetHelper;
import ch.systemsx.cisd.etlserver.DataSetInformation;
import ch.systemsx.cisd.etlserver.HCSImageFileExtractionResult;
import ch.systemsx.cisd.etlserver.IHCSImageFileAccepter;
import ch.systemsx.cisd.etlserver.IHCSImageFileExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HCSImageFileExtractor
implements IHCSImageFileExtractor {
    private static final String TIFF_SUBDIRECTORY = "TIFF";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, HCSImageFileExtractor.class);
    static final String IMAGE_FILE_NOT_STANDARDIZABLE = "Image file '%s' could not be standardized given following tokens [plateLocation=%s,wellLocation=%s,channel=%s].";
    static final String IMAGE_FILE_NOT_ENOUGH_ENTITIES = "Image file '%s' does not have enough entities.";
    static final String IMAGE_FILE_BELONGS_TO_WRONG_SAMPLE = "Image file '%s' belongs to the wrong sample [expected=%s,found=%s].";
    static final String IMAGE_FILE_ACCEPTED = "Image file '%s' was accepted for channel %d, plate location %s and well location %s.";
    static final char TOKEN_SEPARATOR = '_';
    private final Geometry wellGeometry;

    public HCSImageFileExtractor(Properties properties) {
        assert (properties != null) : "Given properites should not be null";
        this.wellGeometry = HCSImageFileExtractor.getWellGeometry(properties);
    }

    private static final Geometry getWellGeometry(Properties properties) {
        String property = properties.getProperty("well_geometry");
        if (property == null) {
            throw new ConfigurationFailureException(String.format("No '%s' property has been specified.", "well_geometry"));
        }
        Geometry geometry = WellGeometry.createFromString(property);
        if (geometry == null) {
            throw new ConfigurationFailureException(String.format("Could not create a geometry from property value '%s'.", property));
        }
        return geometry;
    }

    private final Location tryGetWellLocation(String value) {
        try {
            return Location.tryCreateLocationFromPosition(Integer.parseInt(value), this.wellGeometry);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static final Location tryGetPlateLocation(String value) {
        return Location.tryCreateLocationFromMatrixCoordinate(value);
    }

    private final int getChannelWavelength(String value) {
        if (value.startsWith("w")) {
            try {
                return Integer.parseInt(value.substring("w".length()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    @Override
    public final HCSImageFileExtractionResult process(IDirectory incomingDataSetDirectory, DataSetInformation dataSetInformation, IHCSImageFileAccepter accepter) {
        assert (incomingDataSetDirectory != null);
        List<IFile> imageFiles = this.listTiffFiles(incomingDataSetDirectory);
        long start = System.currentTimeMillis();
        LinkedList<IFile> invalidFiles = new LinkedList<IFile>();
        ChannelWavelengthSortingHCSImageFileAccepterDecorator accepterDecorator = new ChannelWavelengthSortingHCSImageFileAccepterDecorator(accepter);
        for (IFile imageFile : imageFiles) {
            String baseName;
            String[] tokens;
            StopException.check();
            if (operationLog.isDebugEnabled()) {
                operationLog.debug(String.format("Processing image file '%s'", imageFile));
            }
            if ((tokens = StringUtils.split((String)(baseName = FilenameUtils.getBaseName((String)imageFile.getPath())), (char)'_')).length < 4) {
                if (operationLog.isDebugEnabled()) {
                    operationLog.debug(String.format(IMAGE_FILE_NOT_ENOUGH_ENTITIES, imageFile));
                }
                invalidFiles.add(imageFile);
                continue;
            }
            String sampleCode = tokens[tokens.length - 4];
            if (!dataSetInformation.getSampleCode().equals(sampleCode)) {
                if (operationLog.isDebugEnabled()) {
                    operationLog.debug(String.format(IMAGE_FILE_BELONGS_TO_WRONG_SAMPLE, imageFile, dataSetInformation.getSampleCode(), sampleCode));
                }
                invalidFiles.add(imageFile);
                continue;
            }
            String plateLocationStr = tokens[tokens.length - 3];
            Location plateLocation = HCSImageFileExtractor.tryGetPlateLocation(plateLocationStr);
            String wellLocationStr = tokens[tokens.length - 2];
            Location wellLocation = this.tryGetWellLocation(wellLocationStr);
            String channelStr = tokens[tokens.length - 1];
            int channelWavelength = this.getChannelWavelength(channelStr);
            if (wellLocation != null && plateLocation != null && channelWavelength > 0) {
                accepterDecorator.accept(channelWavelength, plateLocation, wellLocation, imageFile);
                if (!operationLog.isDebugEnabled()) continue;
                operationLog.debug(String.format(IMAGE_FILE_ACCEPTED, imageFile, channelWavelength, plateLocation, wellLocation));
                continue;
            }
            if (operationLog.isDebugEnabled()) {
                operationLog.debug(String.format(IMAGE_FILE_NOT_STANDARDIZABLE, imageFile, plateLocationStr, wellLocationStr, channelStr));
            }
            invalidFiles.add(imageFile);
        }
        accepterDecorator.commit();
        return new HCSImageFileExtractionResult(System.currentTimeMillis() - start, imageFiles.size(), Collections.unmodifiableList(invalidFiles), accepterDecorator.getChannels());
    }

    private IDirectory getTiffSubDirectory(IDirectory incomingDataSetDirectory) {
        INode tiffSubDirectoryNodeOrNull = incomingDataSetDirectory.tryGetNode(TIFF_SUBDIRECTORY);
        if (tiffSubDirectoryNodeOrNull == null) {
            throw InvalidExternalDataException.fromTemplate("The directory '%s' does not have a sub-directory '%s'.", incomingDataSetDirectory.getPath(), TIFF_SUBDIRECTORY);
        }
        IDirectory tiffSubDirectoryOrNull = tiffSubDirectoryNodeOrNull.tryAsDirectory();
        if (tiffSubDirectoryOrNull == null) {
            throw InvalidExternalDataException.fromTemplate("The file '%s/%s' is not a directory.", incomingDataSetDirectory.getPath(), TIFF_SUBDIRECTORY);
        }
        return tiffSubDirectoryOrNull;
    }

    List<IFile> listTiffFiles(IDirectory directory) {
        IDirectory tiffSubDirectory = this.getTiffSubDirectory(directory);
        return tiffSubDirectory.listFiles(new String[]{"tif", "tiff"}, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChannelWavelengthSortingHCSImageFileAccepterDecorator
    implements IHCSImageFileAccepter {
        private final IHCSImageFileAccepter accepter;
        private final List<ImageFileRecord> images = new ArrayList<ImageFileRecord>();
        private final ChannelSetHelper helper;

        ChannelWavelengthSortingHCSImageFileAccepterDecorator(IHCSImageFileAccepter accepter) {
            this.accepter = accepter;
            this.helper = new ChannelSetHelper();
        }

        final Set<Channel> getChannels() {
            return this.helper.getChannelSet();
        }

        final void commit() {
            for (ImageFileRecord image : this.images) {
                this.accepter.accept(this.helper.getChannelForWavelength(image.channelWavelength).getCounter(), image.plateLocation, image.wellLocation, image.imageFile);
            }
        }

        @Override
        public final void accept(int channelWavelength, Location wellLocation, Location tileLocation, IFile imageFile) {
            this.images.add(new ImageFileRecord(imageFile, wellLocation, tileLocation, channelWavelength));
            this.helper.addWavelength(channelWavelength);
        }
    }

    private static class ImageFileRecord {
        final IFile imageFile;
        final Location plateLocation;
        final Location wellLocation;
        final int channelWavelength;

        ImageFileRecord(IFile imageFile, Location plateLocation, Location wellLocation, int channelWavelength) {
            this.imageFile = imageFile;
            this.plateLocation = plateLocation;
            this.wellLocation = wellLocation;
            this.channelWavelength = channelWavelength;
        }
    }
}

