/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.base;

import java.util.HashMap;
import java.util.Map;

public final class ExperimentTypeCode {
    private static final String SIRNA_HCS_CODE = "SIRNA_HCS";
    private static final String COMPOUND_HCS_CODE = "COMPOUND_HCS";
    public static final ExperimentTypeCode SIRNA_HCS = new ExperimentTypeCode("SIRNA_HCS");
    public static final ExperimentTypeCode COMPOUND_HCS = new ExperimentTypeCode("COMPOUND_HCS");
    private static final Map<String, ExperimentTypeCode> codeToObjectMap = new HashMap<String, ExperimentTypeCode>();
    private final String code;

    static {
        codeToObjectMap.put(SIRNA_HCS_CODE, SIRNA_HCS);
        codeToObjectMap.put(COMPOUND_HCS_CODE, COMPOUND_HCS);
    }

    private ExperimentTypeCode(String code) {
        this.code = code;
    }

    public final String getCode() {
        return this.code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ExperimentTypeCode getExperimentTypeCode(String typeCode) {
        assert (typeCode != null) : "Unspecified experiment type code.";
        if (typeCode.length() == 0 || !Character.isLetter(typeCode.charAt(0))) {
            throw new IllegalArgumentException(String.format("Illegal experiment type code '%s'.", typeCode));
        }
        String typeCodeUpperCase = typeCode.toUpperCase();
        Map<String, ExperimentTypeCode> map = codeToObjectMap;
        synchronized (map) {
            ExperimentTypeCode typeCodeObject = codeToObjectMap.get(typeCodeUpperCase);
            if (typeCodeObject == null) {
                typeCodeObject = new ExperimentTypeCode(typeCodeUpperCase);
                codeToObjectMap.put(typeCodeUpperCase, typeCodeObject);
            }
            return typeCodeObject;
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExperimentTypeCode other = (ExperimentTypeCode)obj;
        return !(this.code == null ? other.code != null : !this.code.equals(other.code));
    }
}

