/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.base;

import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ProcessingParameters
implements Serializable {
    private static final long serialVersionUID = 18L;
    private String encodedProcessingParameters;
    private transient String fileName;

    public static final ProcessingParameters tryToCreateFromBinary(byte[] bytesOrNull) {
        if (bytesOrNull == null) {
            return null;
        }
        ProcessingParameters processingParameters = new ProcessingParameters();
        try {
            processingParameters.setEncodedProcessingParameters(new String(Base64.encodeBase64((byte[])bytesOrNull), "ASCII"));
        }
        catch (UnsupportedEncodingException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
        return processingParameters;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public final String getEncodedProcessingParameters() {
        return this.encodedProcessingParameters;
    }

    public final void setEncodedProcessingParameters(String encodedProcessingParameters) {
        this.encodedProcessingParameters = encodedProcessingParameters;
    }

    public final byte[] convertToBinary() {
        if (this.encodedProcessingParameters == null) {
            return new byte[0];
        }
        try {
            return Base64.decodeBase64((byte[])this.encodedProcessingParameters.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProcessingParameters)) {
            return false;
        }
        ProcessingParameters that = (ProcessingParameters)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)that.encodedProcessingParameters, (Object)this.encodedProcessingParameters);
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.encodedProcessingParameters);
        return builder.toHashCode();
    }

    public final String toString() {
        return String.valueOf(this.encodedProcessingParameters);
    }
}

