/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.base.properties;

import ch.systemsx.cisd.common.utilities.AbstractHashable;
import ch.systemsx.cisd.lims.base.properties.EntityPropertySchema;
import ch.systemsx.cisd.lims.base.properties.EntityPropertyValue;
import ch.systemsx.cisd.lims.base.properties.IEntityPropertiesSchema;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class EntityProperties
extends AbstractHashable {
    private final IEntityPropertiesSchema propertiesSchema;
    private final Map<String, EntityPropertyValue> properties = new LinkedHashMap<String, EntityPropertyValue>();

    public EntityProperties(IEntityPropertiesSchema propertiesSchema) {
        this.propertiesSchema = propertiesSchema;
        this.createInitialProperties();
    }

    private final void createInitialProperties() {
        String[] stringArray = this.propertiesSchema.getAllNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            EntityPropertySchema spec = this.propertiesSchema.getPropertySchema(name);
            EntityPropertyValue value = EntityPropertyValue.createFromUntyped(null, spec.getDataTypeCode());
            this.properties.put(name, value);
            ++n2;
        }
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public final EntityPropertyValue getProperty(String name) throws IllegalArgumentException {
        EntityPropertyValue value = this.properties.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No entity property value for '" + name + "'.");
        }
        return value;
    }

    public final void setProperty(String name, String untypedValueOrNull) {
        EntityPropertyValue value = this.propertiesSchema.validateAndCreateValue(name, untypedValueOrNull);
        this.properties.put(name, value);
    }

    public static EntityProperties createFromSimple(SimpleEntityProperty[] simpleProperties, IEntityPropertiesSchema propertySchema) {
        if (simpleProperties == null) {
            return null;
        }
        EntityProperties properties = new EntityProperties(propertySchema);
        int i = 0;
        while (i < simpleProperties.length) {
            SimpleEntityProperty property = simpleProperties[i];
            String name = property.getCode();
            if (!propertySchema.hasPropertySchema(name)) {
                throw new IllegalArgumentException("Unknown property '" + name + "'.");
            }
            properties.setProperty(name, EntityPropertyValue.createFromSimple(property).tryGetUntypedValue());
            ++i;
        }
        return properties;
    }

    public SimpleEntityProperty[] createSimple() {
        ArrayList<SimpleEntityProperty> result = new ArrayList<SimpleEntityProperty>();
        for (Map.Entry<String, EntityPropertyValue> entry : this.properties.entrySet()) {
            String userLabel = this.propertiesSchema.getPropertySchema(entry.getKey()).getUserLabel();
            result.add(entry.getValue().createSimple(entry.getKey(), userLabel));
        }
        return result.toArray(new SimpleEntityProperty[result.size()]);
    }
}

