/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j;

import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineOptionPrinter;
import org.kohsuke.args4j.CmdLineOptions;
import org.kohsuke.args4j.CmdLineParameters;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.FieldSetter;
import org.kohsuke.args4j.HandlerClasses;
import org.kohsuke.args4j.IllegalAnnotationError;
import org.kohsuke.args4j.Messages;
import org.kohsuke.args4j.MethodSetter;
import org.kohsuke.args4j.MultiValueFieldSetter;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdLineParser {
    private final Object bean;
    private final CmdLineOptions options = new CmdLineOptions();
    private final CmdLineOptionPrinter optionPrinter = new CmdLineOptionPrinter(this.options);
    private Setter<String> argumentSetter;

    public CmdLineParser(Object bean) {
        this.bean = bean;
        Class<?> c = bean.getClass();
        while (c != null) {
            Argument a;
            Option o;
            AccessibleObject[] accessibleObjectArray = c.getDeclaredMethods();
            int n = 0;
            int n2 = accessibleObjectArray.length;
            while (n < n2) {
                Method m = accessibleObjectArray[n];
                o = m.getAnnotation(Option.class);
                if (o != null) {
                    this.options.addOption(new MethodSetter(bean, m), o);
                }
                if ((a = m.getAnnotation(Argument.class)) != null) {
                    this.addArgument(new MethodSetter<String>(bean, m));
                }
                ++n;
            }
            accessibleObjectArray = c.getDeclaredFields();
            n = 0;
            n2 = accessibleObjectArray.length;
            while (n < n2) {
                AccessibleObject f = accessibleObjectArray[n];
                o = ((Field)f).getAnnotation(Option.class);
                if (o != null) {
                    this.options.addOption(this.createFieldSetter((Field)f), o);
                }
                if ((a = ((Field)f).getAnnotation(Argument.class)) != null) {
                    this.addArgument(this.createFieldSetter((Field)f));
                }
                ++n;
            }
            c = c.getSuperclass();
        }
    }

    private Setter createFieldSetter(Field f) {
        if (List.class.isAssignableFrom(f.getType())) {
            return new MultiValueFieldSetter(this.bean, f);
        }
        return new FieldSetter(this.bean, f);
    }

    private void addArgument(Setter<String> setter) {
        if (this.argumentSetter != null) {
            throw new IllegalAnnotationError("@Argument is used more than once");
        }
        this.argumentSetter = setter;
    }

    public void printHelp(String programCall, String genericOptions, String genericArgs, ExampleMode mode) {
        this.optionPrinter.printHelp(programCall, genericOptions, genericArgs, mode);
    }

    public String printExample(ExampleMode mode) {
        return this.optionPrinter.getExampleString(mode);
    }

    public String printExample(ExampleMode mode, ResourceBundle rb) {
        return this.optionPrinter.getExampleString(mode, rb);
    }

    public void printUsage(OutputStream out) {
        this.optionPrinter.printUsage(out);
    }

    public void printUsage(Writer out, ResourceBundle rb) {
        this.optionPrinter.printUsage(out, rb);
    }

    public void parseArgument(String ... args) throws CmdLineException {
        CmdLineParameters cmdLine = new CmdLineParameters(args);
        HashSet<OptionHandler> present = new HashSet<OptionHandler>();
        boolean endOfOptionMarkerFound = false;
        char quotedArgChar = '\u0000';
        StringBuilder quotedArg = new StringBuilder();
        block0: while (cmdLine.hasMore()) {
            String arg = cmdLine.getOptionName();
            if (!endOfOptionMarkerFound && this.isOption(arg)) {
                OptionHandler handler;
                endOfOptionMarkerFound = this.isEndOfOptionMarker(arg);
                if (endOfOptionMarkerFound) {
                    cmdLine.proceed(1);
                    continue;
                }
                int eqIdx = arg.indexOf(61);
                if (eqIdx == -1) {
                    handler = this.options.getHandlerForOption(arg);
                    if (handler != null) {
                        int diff = handler.parseArguments(cmdLine);
                        cmdLine.proceed(diff + 1);
                        present.add(handler);
                        continue;
                    }
                    if (!this.isLongOption(arg)) {
                        int len = arg.length();
                        while (--len > 0) {
                            String optionOnTrial = arg.substring(0, len);
                            handler = this.options.getHandlerForOption(optionOnTrial);
                            if (handler == null) continue;
                            handler.set(arg.substring(len));
                            cmdLine.proceed(1);
                            present.add(handler);
                            continue block0;
                        }
                    }
                } else {
                    handler = this.options.getHandlerForOption(arg.substring(0, eqIdx));
                    if (handler != null) {
                        handler.set(arg.substring(eqIdx + 1));
                        cmdLine.proceed(1);
                        present.add(handler);
                        continue;
                    }
                }
                throw new CmdLineException(Messages.UNDEFINED_OPTION.format(arg));
            }
            if (this.argumentSetter == null) {
                throw new CmdLineException(Messages.NO_ARGUMENT_ALLOWED.format(arg));
            }
            if (quotedArgChar == '\u0000') {
                if (this.isQuotedArgStarting(arg)) {
                    quotedArgChar = arg.charAt(0);
                    quotedArg.append(arg.substring(1));
                } else {
                    this.argumentSetter.addValue(arg);
                }
            } else if (arg.endsWith(String.valueOf(quotedArgChar))) {
                quotedArg.append(arg.substring(0, arg.length() - 1));
                quotedArgChar = '\u0000';
                this.argumentSetter.addValue(quotedArg.toString());
                quotedArg.setLength(0);
            } else {
                quotedArg.append(arg);
            }
            cmdLine.proceed(1);
        }
        this.options.checkRequiredOptionsPresent(present);
    }

    private boolean isQuotedArgStarting(String arg) {
        return arg.startsWith("'") || arg.startsWith("\"");
    }

    private boolean isOption(String arg) {
        return arg.startsWith("-");
    }

    private boolean isLongOption(String arg) {
        return arg.startsWith("--");
    }

    private boolean isEndOfOptionMarker(String arg) {
        return "--".equals(arg);
    }

    @Deprecated
    public static void registerHandler(Class valueType, Class<? extends OptionHandler> handlerClass) {
        HandlerClasses.registerHandler(valueType, handlerClass);
    }

    public void setUsageWidth(int usageWidth) {
        this.optionPrinter.setTerminalWidth(usageWidth);
    }
}

