/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.file;

import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.authentication.file.FileBasedLineStore;
import ch.systemsx.cisd.authentication.file.IUserStore;
import ch.systemsx.cisd.authentication.file.LineBasedUserStore;
import ch.systemsx.cisd.authentication.file.UserEntry;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import org.apache.log4j.Logger;

public class FileAuthenticationService
implements IAuthenticationService {
    private static final String TOKEN_FAILURE_MSG_TEMPLATE = "Wrong application token provided, expected '%s', got '%s'";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FileAuthenticationService.class);
    private final IUserStore userStore;

    private static IUserStore createUserStore(String passwordFileName) {
        FileBasedLineStore lineStore = new FileBasedLineStore(new File(passwordFileName), "Password file");
        return new LineBasedUserStore(lineStore);
    }

    public FileAuthenticationService(String passwordFileName) {
        this(FileAuthenticationService.createUserStore(passwordFileName));
    }

    public FileAuthenticationService(IUserStore userStore) {
        this.userStore = userStore;
        userStore.check();
    }

    private String getToken() {
        return this.userStore.getId();
    }

    public String authenticateApplication() {
        return this.getToken();
    }

    public boolean authenticateUser(String applicationToken, String user, String password) {
        String token = this.getToken();
        if (!token.equals(applicationToken)) {
            operationLog.warn(String.format(TOKEN_FAILURE_MSG_TEMPLATE, token, applicationToken));
            return false;
        }
        return this.userStore.isPasswordCorrect(user, password);
    }

    public Principal getPrincipal(String applicationToken, String user) {
        String token = this.getToken();
        if (!token.equals(applicationToken)) {
            operationLog.warn(String.format(TOKEN_FAILURE_MSG_TEMPLATE, token, applicationToken));
            return null;
        }
        UserEntry userOrNull = this.userStore.tryGetUser(user);
        if (userOrNull == null) {
            throw new IllegalArgumentException("Cannot find user '" + user + "'.");
        }
        return userOrNull.asPrincipal();
    }

    public void check() throws EnvironmentFailureException, ConfigurationFailureException {
        this.userStore.check();
    }
}

