/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.logging;

import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogAnnotation;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogLevel;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogInvocationHandler
implements InvocationHandler {
    private final Object object;
    private final String name;
    private final Level defaultLogLevel;
    private final Class<?> classUsedToNameLogger;

    public LogInvocationHandler(Object object, String name, Level logLevel, Class<?> classUsedToNameLogger) {
        this.object = object;
        this.name = name;
        this.defaultLogLevel = logLevel;
        this.classUsedToNameLogger = classUsedToNameLogger;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        StringBuilder builder;
        Logger logger;
        Level logLevel;
        Throwable throwable3;
        Throwable throwable2;
        long time;
        block15: {
            int i;
            block16: {
                Object object;
                time = System.currentTimeMillis();
                throwable2 = null;
                try {
                    object = method.invoke(this.object, args);
                }
                catch (InvocationTargetException e) {
                    try {
                        throwable2 = e.getCause();
                        throw throwable2;
                        catch (UndeclaredThrowableException e2) {
                            throwable2 = e2.getCause();
                            throw throwable2;
                        }
                        catch (Throwable t) {
                            throwable2 = t;
                            throw t;
                        }
                    }
                    catch (Throwable throwable3) {
                        logLevel = this.getLogLevel(method);
                        logger = this.createLogger(method);
                        if (throwable2 == null) {
                            if (!logger.isEnabledFor(logLevel)) throw throwable3;
                        }
                        builder = new StringBuilder(throwable2 == null ? "Successful" : "Failed");
                        builder.append(" invocation of ");
                        builder.append(this.name).append('.').append(method.getName()).append('(');
                        if (args == null) break block15;
                        i = 0;
                        break block16;
                    }
                }
                Level logLevel2 = this.getLogLevel(method);
                Logger logger2 = this.createLogger(method);
                if (throwable2 == null) {
                    if (!logger2.isEnabledFor(logLevel2)) return object;
                }
                StringBuilder builder2 = new StringBuilder(throwable2 == null ? "Successful" : "Failed");
                builder2.append(" invocation of ");
                builder2.append(this.name).append('.').append(method.getName()).append('(');
                if (args != null) {
                    int i2 = 0;
                    while (i2 < args.length) {
                        builder2.append(args[i2]);
                        if (i2 < args.length - 1) {
                            builder2.append(", ");
                        }
                        ++i2;
                    }
                }
                builder2.append(") took ").append(System.currentTimeMillis() - time).append(" msec");
                if (throwable2 == null) {
                    logger2.log(logLevel2, builder2.toString());
                    return object;
                }
                logger2.error(builder2.toString(), throwable2);
                return object;
            }
            while (i < args.length) {
                builder.append(args[i]);
                if (i < args.length - 1) {
                    builder.append(", ");
                }
                ++i;
            }
        }
        builder.append(") took ").append(System.currentTimeMillis() - time).append(" msec");
        if (throwable2 == null) {
            logger.log(logLevel, builder.toString());
            throw throwable3;
        }
        logger.error(builder.toString(), throwable2);
        throw throwable3;
    }

    private Level getLogLevel(Method method) {
        LogAnnotation annotation = method.getAnnotation(LogAnnotation.class);
        if (annotation == null) {
            return Level.DEBUG;
        }
        if (annotation.logLevel().equals((Object)LogLevel.UNDEFINED)) {
            return this.defaultLogLevel;
        }
        return Log4jSimpleLogger.toLog4jPriority(annotation.logLevel());
    }

    private Logger createLogger(Method method) {
        LogAnnotation annotation = method.getAnnotation(LogAnnotation.class);
        LogCategory logCategory = annotation == null ? LogCategory.OPERATION : annotation.logCategory();
        return LogFactory.getLogger(logCategory, this.classUsedToNameLogger);
    }
}

