/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration.h2;

import ch.systemsx.cisd.common.Script;
import ch.systemsx.cisd.common.db.ISqlScriptExecutor;
import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.dbmigration.IDatabaseAdminDAO;
import ch.systemsx.cisd.dbmigration.IMassUploader;
import ch.systemsx.cisd.dbmigration.MassUploadFileType;
import java.io.File;
import java.io.FilenameFilter;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.h2.tools.DeleteDbFiles;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;

public class H2AdminDAO
extends SimpleJdbcDaoSupport
implements IDatabaseAdminDAO {
    private static final String DROP_ALL_OBJECTS_SQL = "drop all objects;";
    private static final String SQL_FILE_TYPE = ".sql";
    private static final Pattern dbDirPartPattern = Pattern.compile(".*:file:(.*?)/.*");
    private static final String CREATE_TABLE_DATABASE_VERSION_LOGS_SQL = "create table database_version_logs (db_version varchar(4) not null, module_name varchar(250), run_status varchar(10), run_status_timestamp timestamp, module_code bytea, run_exception bytea);";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, H2AdminDAO.class);
    private final String databaseName;
    private final String databaseDir;
    private final String databaseURL;
    private final ISqlScriptExecutor scriptExecutor;
    private final IMassUploader massUploader;

    public H2AdminDAO(DataSource dataSource, ISqlScriptExecutor scriptExecutor, IMassUploader massUploader, String databaseName, String databaseURL) {
        this.scriptExecutor = scriptExecutor;
        this.massUploader = massUploader;
        this.databaseName = databaseName;
        this.databaseURL = databaseURL;
        Matcher dbDirPartMatcherOrNull = dbDirPartPattern.matcher(databaseURL);
        this.databaseDir = dbDirPartMatcherOrNull.matches() ? dbDirPartMatcherOrNull.group(1) : ".";
        this.setDataSource(dataSource);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabaseURL() {
        return this.databaseURL;
    }

    public void createOwner() {
    }

    public void createDatabase() {
        this.createDatabaseVersionLogsTable();
    }

    private void createDatabaseVersionLogsTable() {
        try {
            this.scriptExecutor.execute(new Script("create database_version_logs table", CREATE_TABLE_DATABASE_VERSION_LOGS_SQL), true, null);
        }
        catch (RuntimeException ex) {
            operationLog.error("Failed to create database_version_logs table.", ex);
            throw ex;
        }
    }

    public void dropDatabase() {
        this.scriptExecutor.execute(new Script("drop database", DROP_ALL_OBJECTS_SQL), true, null);
        try {
            DeleteDbFiles.execute((String)this.databaseDir, (String)this.databaseName, (boolean)true);
        }
        catch (SQLException ex) {
            throw new CheckedExceptionTunnel(ex);
        }
    }

    public void restoreDatabaseFromDump(File dumpFolder, String version) {
        this.createDatabaseVersionLogsTable();
        Script schemaScript = this.tryLoadScript(dumpFolder, "schema", version);
        this.scriptExecutor.execute(schemaScript, true, null);
        File[] massUploadFiles = this.getMassUploadFiles(dumpFolder);
        this.massUploader.performMassUpload(massUploadFiles);
        Script finishScript = this.tryLoadScript(dumpFolder, "finish", version);
        this.scriptExecutor.execute(finishScript, true, null);
    }

    private Script tryLoadScript(File dumpFolder, String prefix, String version) throws ConfigurationFailureException {
        File scriptFile = new File(dumpFolder, String.valueOf(prefix) + "-" + version + SQL_FILE_TYPE);
        if (!scriptFile.canRead()) {
            String message = "No " + prefix + " script found for version " + version;
            operationLog.error(message);
            throw new ConfigurationFailureException(message);
        }
        Script script = new Script(scriptFile.getPath(), FileUtilities.loadToString(scriptFile), version);
        return script;
    }

    private File[] getMassUploadFiles(File dumpFolder) {
        Object[] csvFiles;
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("Searching for mass upload files in directory '" + dumpFolder.getAbsolutePath() + "'.");
        }
        if ((csvFiles = dumpFolder.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return MassUploadFileType.CSV.isOfType(name) || MassUploadFileType.TSV.isOfType(name);
            }
        })) == null) {
            operationLog.warn("Path '" + dumpFolder.getAbsolutePath() + "' is not a directory.");
            return new File[0];
        }
        Arrays.sort(csvFiles);
        if (operationLog.isInfoEnabled()) {
            operationLog.info("Found " + csvFiles.length + " files for mass uploading.");
        }
        File[] csvPaths = new File[csvFiles.length];
        int i = 0;
        while (i < csvFiles.length) {
            csvPaths[i] = new File(dumpFolder, (String)csvFiles[i]);
            ++i;
        }
        return csvPaths;
    }
}

