/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.base;

import java.util.HashMap;
import java.util.Map;

public final class SampleTypeCode {
    private static final Map<String, SampleTypeCode> codeToObjectMap = new HashMap<String, SampleTypeCode>();
    private static final String MASTER_PLATE_CODE = "MASTER_PLATE";
    private static final String DILUTION_PLATE_CODE = "DILUTION_PLATE";
    private static final String CELL_PLATE_CODE = "CELL_PLATE";
    private static final String REINFECT_PLATE_CODE = "REINFECT_PLATE";
    private static final String CONTROL_LAYOUT_CODE = "CONTROL_LAYOUT";
    public static final SampleTypeCode MASTER_PLATE = new SampleTypeCode("MASTER_PLATE", false, true);
    public static final SampleTypeCode DILUTION_PLATE = new SampleTypeCode("DILUTION_PLATE", true, true);
    public static final SampleTypeCode CELL_PLATE = new SampleTypeCode("CELL_PLATE", true, true);
    public static final SampleTypeCode REINFECT_PLATE = new SampleTypeCode("REINFECT_PLATE", true, "reinfection plate", true);
    public static final SampleTypeCode CONTROL_LAYOUT = new SampleTypeCode("CONTROL_LAYOUT", false, true);
    private final String code;
    private final boolean parentRequired;
    private final String label;
    private final boolean screeningPlate;

    static {
        codeToObjectMap.put(MASTER_PLATE_CODE, MASTER_PLATE);
        codeToObjectMap.put(DILUTION_PLATE_CODE, DILUTION_PLATE);
        codeToObjectMap.put(CELL_PLATE_CODE, CELL_PLATE);
        codeToObjectMap.put(REINFECT_PLATE_CODE, REINFECT_PLATE);
        codeToObjectMap.put(CONTROL_LAYOUT_CODE, CONTROL_LAYOUT);
    }

    private SampleTypeCode(String code, boolean parentRequired, boolean screeningPlate) {
        this(code, parentRequired, SampleTypeCode.codeToLabel(code), screeningPlate);
    }

    private SampleTypeCode(String code, boolean parentRequired, String label, boolean screeningPlate) {
        this.code = code;
        this.parentRequired = parentRequired;
        this.label = label;
        this.screeningPlate = screeningPlate;
    }

    private static String codeToLabel(String code) {
        return code.toLowerCase().replaceAll("_", " ");
    }

    public final String getCode() {
        return this.code;
    }

    public final boolean isParentRequired() {
        return this.parentRequired;
    }

    public final boolean isScreeningPlate() {
        return this.screeningPlate;
    }

    public final String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SampleTypeCode getSampleTypeCode(String typeCode) {
        assert (typeCode != null) : "Unspecified sample type code.";
        if (typeCode.length() == 0 || !Character.isLetter(typeCode.charAt(0))) {
            throw new IllegalArgumentException(String.format("Illegal sample type code '%s'.", typeCode));
        }
        String typeCodeUpperCase = typeCode.toUpperCase();
        Map<String, SampleTypeCode> map = codeToObjectMap;
        synchronized (map) {
            SampleTypeCode typeCodeObject = codeToObjectMap.get(typeCodeUpperCase);
            if (typeCodeObject == null) {
                typeCodeObject = new SampleTypeCode(typeCodeUpperCase, false, false);
                codeToObjectMap.put(typeCodeUpperCase, typeCodeObject);
            }
            return typeCodeObject;
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SampleTypeCode other = (SampleTypeCode)obj;
        return !(this.code == null ? other.code != null : !this.code.equals(other.code));
    }

    public String toString() {
        return this.code;
    }
}

