/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.BuildAndEnvironmentInfo;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.lims.client.commands.AddExperimentAttachmentCommand;
import ch.systemsx.cisd.lims.client.commands.AssignControlLayoutPropertyTypeCommand;
import ch.systemsx.cisd.lims.client.commands.AssignExperimentPropertyTypeCommand;
import ch.systemsx.cisd.lims.client.commands.AssignMaterialPropertyTypeCommand;
import ch.systemsx.cisd.lims.client.commands.AssignPlatePropertyTypeCommand;
import ch.systemsx.cisd.lims.client.commands.AssignSamplePropertyTypeCommand;
import ch.systemsx.cisd.lims.client.commands.GetControlLayoutInfoCommand;
import ch.systemsx.cisd.lims.client.commands.GetControlLayoutTypeInfoCommand;
import ch.systemsx.cisd.lims.client.commands.GetDatasetsCommand;
import ch.systemsx.cisd.lims.client.commands.GetExperimentAttachmentCommand;
import ch.systemsx.cisd.lims.client.commands.GetExperimentInfoCommand;
import ch.systemsx.cisd.lims.client.commands.GetExperimentTypeInfoCommand;
import ch.systemsx.cisd.lims.client.commands.GetMaterialTypeInfoCommand;
import ch.systemsx.cisd.lims.client.commands.GetPlateInfoCommand;
import ch.systemsx.cisd.lims.client.commands.GetPlateLocationsCommand;
import ch.systemsx.cisd.lims.client.commands.GetPlateTypeInfoCommand;
import ch.systemsx.cisd.lims.client.commands.GetVocabularyInfoCommand;
import ch.systemsx.cisd.lims.client.commands.ICommand;
import ch.systemsx.cisd.lims.client.commands.InvalidateExperimentCommand;
import ch.systemsx.cisd.lims.client.commands.InvalidatePlatesCommand;
import ch.systemsx.cisd.lims.client.commands.ListContactsCommand;
import ch.systemsx.cisd.lims.client.commands.ListControlLayoutPropertyTypesCommand;
import ch.systemsx.cisd.lims.client.commands.ListControlLayoutsCommand;
import ch.systemsx.cisd.lims.client.commands.ListExperimentAttachmentsCommand;
import ch.systemsx.cisd.lims.client.commands.ListExperimentDatasetsCommand;
import ch.systemsx.cisd.lims.client.commands.ListExperimentPlatesCommand;
import ch.systemsx.cisd.lims.client.commands.ListExperimentPropertyTypesCommand;
import ch.systemsx.cisd.lims.client.commands.ListExperimentSamplesCommand;
import ch.systemsx.cisd.lims.client.commands.ListExperimentTypesCommand;
import ch.systemsx.cisd.lims.client.commands.ListExperimentsCommand;
import ch.systemsx.cisd.lims.client.commands.ListFileFormatTypesCommand;
import ch.systemsx.cisd.lims.client.commands.ListMaterialPropertyTypesCommand;
import ch.systemsx.cisd.lims.client.commands.ListMaterialTypesCommand;
import ch.systemsx.cisd.lims.client.commands.ListMaterialsCommand;
import ch.systemsx.cisd.lims.client.commands.ListObservableTypesCommand;
import ch.systemsx.cisd.lims.client.commands.ListPlatePropertyTypesCommand;
import ch.systemsx.cisd.lims.client.commands.ListPlateTypesCommand;
import ch.systemsx.cisd.lims.client.commands.ListPlatesCommand;
import ch.systemsx.cisd.lims.client.commands.ListProcessingInstructionsCommand;
import ch.systemsx.cisd.lims.client.commands.ListProjectsCommand;
import ch.systemsx.cisd.lims.client.commands.ListPropertyTypesCommand;
import ch.systemsx.cisd.lims.client.commands.ListSamplesCommand;
import ch.systemsx.cisd.lims.client.commands.ListVocabulariesCommand;
import ch.systemsx.cisd.lims.client.commands.LoginCommand;
import ch.systemsx.cisd.lims.client.commands.LogoutCommand;
import ch.systemsx.cisd.lims.client.commands.RegisterCellPlatesCommand;
import ch.systemsx.cisd.lims.client.commands.RegisterControlLayoutCommand;
import ch.systemsx.cisd.lims.client.commands.RegisterDataSetCommand;
import ch.systemsx.cisd.lims.client.commands.RegisterDilutionPlatesCommand;
import ch.systemsx.cisd.lims.client.commands.RegisterExperimentCommand;
import ch.systemsx.cisd.lims.client.commands.RegisterExperimentTypeCommand;
import ch.systemsx.cisd.lims.client.commands.RegisterFileFormatTypeCommand;
import ch.systemsx.cisd.lims.client.commands.RegisterMasterPlateCommand;
import ch.systemsx.cisd.lims.client.commands.RegisterMaterialTypeCommand;
import ch.systemsx.cisd.lims.client.commands.RegisterMaterialsCommand;
import ch.systemsx.cisd.lims.client.commands.RegisterObservableTypeCommand;
import ch.systemsx.cisd.lims.client.commands.RegisterProjectCommand;
import ch.systemsx.cisd.lims.client.commands.RegisterPropertyTypesCommand;
import ch.systemsx.cisd.lims.client.commands.RegisterReinfectionPlatesCommand;
import ch.systemsx.cisd.lims.client.commands.RegisterSampleTypeCommand;
import ch.systemsx.cisd.lims.client.commands.RegisterSamplesCommand;
import ch.systemsx.cisd.lims.client.commands.RegisterVocabularyCommand;
import ch.systemsx.cisd.lims.client.commands.SearchCommand;
import ch.systemsx.cisd.lims.client.commands.SetExperimentPropertyCommand;
import ch.systemsx.cisd.lims.client.commands.SetMaterialPropertyCommand;
import ch.systemsx.cisd.lims.client.commands.SetSamplePropertyCommand;
import ch.systemsx.cisd.lims.client.commands.UnassignControlLayoutPropertyTypeCommand;
import ch.systemsx.cisd.lims.client.commands.UnassignExperimentPropertyTypeCommand;
import ch.systemsx.cisd.lims.client.commands.UnassignMaterialPropertyTypeCommand;
import ch.systemsx.cisd.lims.client.commands.UnassignPlatePropertyTypeCommand;
import ch.systemsx.cisd.lims.client.commands.UnassignSamplePropertyTypeCommand;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.varia.NullAppender;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteConnectFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LIMSClient {
    static IExitHandler exitHandler = SystemExit.SYSTEM_EXIT;
    private static final Map<String, ICommand> commands = LIMSClient.createCommands();

    private static final void init() {
        BasicConfigurator.configure(new NullAppender());
    }

    private static final void printUsage() {
        String cmd = "java " + LIMSClient.class.getName() + " <command>";
        System.err.println("Usage: " + cmd + " <options> ");
        System.err.println();
        System.err.println("Possible commands are: ");
        System.err.println();
        LIMSClient.printCommands();
        System.err.println();
        System.err.println("Type '" + cmd + " --help' for help on a specific command");
    }

    private static final void printCommands() {
        for (String command : commands.keySet()) {
            System.err.println(command);
        }
    }

    private static final void printVersion() {
        System.err.println("openBIS version " + BuildAndEnvironmentInfo.INSTANCE.getFullVersion() + " (Web Services version " + 18 + ")");
    }

    public static void main(String[] args) throws Exception {
        LIMSClient.init();
        if (args.length == 1 && "--version".equals(args[0])) {
            LIMSClient.printVersion();
            exitHandler.exit(1);
        }
        Set<String> commandNames = commands.keySet();
        if (args.length == 0 || !commandNames.contains(args[0])) {
            LIMSClient.printUsage();
            exitHandler.exit(1);
        }
        String[] newArgs = (String[])ArrayUtils.remove(args, 0);
        ICommand command = commands.get(args[0]);
        try {
            exitHandler.exit(command.execute(newArgs));
        }
        catch (UserFailureException ex) {
            System.err.println(String.valueOf(ex.getMessage()) + " (user fault)");
            exitHandler.exit(1);
        }
        catch (EnvironmentFailureException ex) {
            System.err.println(String.valueOf(ex.getMessage()) + " (environment failure)");
            exitHandler.exit(1);
        }
        catch (RemoteConnectFailureException remoteConnectFailureException) {
            System.err.println("Remote server cannot be reached (environment failure)");
            exitHandler.exit(1);
        }
        catch (RemoteAccessException ex) {
            Throwable cause = ex.getCause();
            if (cause != null) {
                if (cause instanceof UnknownHostException) {
                    System.err.println(String.format("Given host '%s' can not be reached  (environment failure)", cause.getMessage()));
                } else if (cause instanceof IllegalArgumentException) {
                    System.err.println(cause.getMessage());
                } else if (cause instanceof SSLHandshakeException) {
                    System.err.println(String.format("Validation of SSL certificate failed [%s=%s] (configuration failure)", "javax.net.ssl.trustStore", StringUtils.defaultString(System.getProperty("javax.net.ssl.trustStore"))));
                } else {
                    ex.printStackTrace();
                }
            } else {
                ex.printStackTrace();
            }
            exitHandler.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            exitHandler.exit(1);
        }
    }

    private static final Map<String, ICommand> createCommands() {
        TreeMap<String, ICommand> map = new TreeMap<String, ICommand>();
        LIMSClient.registerCommand(map, LoginCommand.getInstance());
        LIMSClient.registerCommand(map, LogoutCommand.getInstance());
        LIMSClient.registerCommand(map, RegisterExperimentCommand.getInstance());
        LIMSClient.registerCommand(map, RegisterExperimentTypeCommand.getInstance());
        LIMSClient.registerCommand(map, AddExperimentAttachmentCommand.getInstance());
        LIMSClient.registerCommand(map, ListExperimentsCommand.getInstance());
        LIMSClient.registerCommand(map, GetExperimentInfoCommand.getInstance());
        LIMSClient.registerCommand(map, GetExperimentAttachmentCommand.getInstance());
        LIMSClient.registerCommand(map, ListExperimentTypesCommand.getInstance());
        LIMSClient.registerCommand(map, ListMaterialTypesCommand.getInstance());
        LIMSClient.registerCommand(map, GetMaterialTypeInfoCommand.getInstance());
        LIMSClient.registerCommand(map, GetExperimentTypeInfoCommand.getInstance());
        LIMSClient.registerCommand(map, GetPlateTypeInfoCommand.getInstance());
        LIMSClient.registerCommand(map, ListPropertyTypesCommand.getInstance());
        LIMSClient.registerCommand(map, AssignMaterialPropertyTypeCommand.getInstance());
        LIMSClient.registerCommand(map, ListMaterialsCommand.getInstance());
        LIMSClient.registerCommand(map, ListContactsCommand.getInstance());
        LIMSClient.registerCommand(map, RegisterDataSetCommand.getInstance());
        LIMSClient.registerCommand(map, ListSamplesCommand.getInstance());
        LIMSClient.registerCommand(map, ListPlatesCommand.getInstance());
        LIMSClient.registerCommand(map, RegisterMasterPlateCommand.getInstance());
        LIMSClient.registerCommand(map, GetPlateLocationsCommand.getInstance());
        LIMSClient.registerCommand(map, RegisterControlLayoutCommand.getInstance());
        LIMSClient.registerCommand(map, GetControlLayoutInfoCommand.getInstance());
        LIMSClient.registerCommand(map, ListProjectsCommand.getInstance());
        LIMSClient.registerCommand(map, RegisterProjectCommand.getInstance());
        LIMSClient.registerCommand(map, RegisterDilutionPlatesCommand.getInstance());
        LIMSClient.registerCommand(map, RegisterCellPlatesCommand.getInstance());
        LIMSClient.registerCommand(map, InvalidatePlatesCommand.getInstance());
        LIMSClient.registerCommand(map, RegisterReinfectionPlatesCommand.getInstance());
        LIMSClient.registerCommand(map, RegisterSamplesCommand.getInstance());
        LIMSClient.registerCommand(map, RegisterSampleTypeCommand.getInstance());
        LIMSClient.registerCommand(map, GetPlateInfoCommand.getInstance());
        LIMSClient.registerCommand(map, RegisterMaterialsCommand.getInstance());
        LIMSClient.registerCommand(map, RegisterMaterialTypeCommand.getInstance());
        LIMSClient.registerCommand(map, RegisterPropertyTypesCommand.getInstance());
        LIMSClient.registerCommand(map, UnassignMaterialPropertyTypeCommand.getInstance());
        LIMSClient.registerCommand(map, UnassignExperimentPropertyTypeCommand.getInstance());
        LIMSClient.registerCommand(map, UnassignControlLayoutPropertyTypeCommand.getInstance());
        LIMSClient.registerCommand(map, UnassignSamplePropertyTypeCommand.getInstance());
        LIMSClient.registerCommand(map, UnassignPlatePropertyTypeCommand.getInstance());
        LIMSClient.registerCommand(map, InvalidateExperimentCommand.getInstance());
        LIMSClient.registerCommand(map, RegisterVocabularyCommand.getInstance());
        LIMSClient.registerCommand(map, ListVocabulariesCommand.getInstance());
        LIMSClient.registerCommand(map, GetVocabularyInfoCommand.getInstance());
        LIMSClient.registerCommand(map, ListPlateTypesCommand.getInstance());
        LIMSClient.registerCommand(map, AssignControlLayoutPropertyTypeCommand.getInstance());
        LIMSClient.registerCommand(map, AssignPlatePropertyTypeCommand.getInstance());
        LIMSClient.registerCommand(map, AssignSamplePropertyTypeCommand.getInstance());
        LIMSClient.registerCommand(map, AssignExperimentPropertyTypeCommand.getInstance());
        LIMSClient.registerCommand(map, GetControlLayoutTypeInfoCommand.getInstance());
        LIMSClient.registerCommand(map, ListMaterialPropertyTypesCommand.getInstance());
        LIMSClient.registerCommand(map, ListPlatePropertyTypesCommand.getInstance());
        LIMSClient.registerCommand(map, ListExperimentPropertyTypesCommand.getInstance());
        LIMSClient.registerCommand(map, ListExperimentAttachmentsCommand.getInstance());
        LIMSClient.registerCommand(map, ListExperimentPlatesCommand.getInstance());
        LIMSClient.registerCommand(map, ListExperimentSamplesCommand.getInstance());
        LIMSClient.registerCommand(map, ListProcessingInstructionsCommand.getInstance());
        LIMSClient.registerCommand(map, ListExperimentDatasetsCommand.getInstance());
        LIMSClient.registerCommand(map, ListControlLayoutsCommand.getInstance());
        LIMSClient.registerCommand(map, ListControlLayoutPropertyTypesCommand.getInstance());
        LIMSClient.registerCommand(map, ListFileFormatTypesCommand.getInstance());
        LIMSClient.registerCommand(map, RegisterFileFormatTypeCommand.getInstance());
        LIMSClient.registerCommand(map, ListObservableTypesCommand.getInstance());
        LIMSClient.registerCommand(map, RegisterObservableTypeCommand.getInstance());
        LIMSClient.registerCommand(map, SetSamplePropertyCommand.getInstance());
        LIMSClient.registerCommand(map, SetMaterialPropertyCommand.getInstance());
        LIMSClient.registerCommand(map, SetExperimentPropertyCommand.getInstance());
        LIMSClient.registerCommand(map, GetDatasetsCommand.getInstance());
        LIMSClient.registerCommand(map, SearchCommand.getInstance());
        return map;
    }

    private static void registerCommand(Map<String, ICommand> map, ICommand command) {
        for (String name : command.getAliasNames()) {
            if (map.containsKey(name)) {
                throw new Error("A command named '" + name + "' has already been registered.");
            }
            map.put(name, command);
        }
    }
}

