/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.io.ILinePrinter;
import ch.systemsx.cisd.common.io.SimpleLinePrinter;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.RMIBasedLIMSServiceFactory;
import ch.systemsx.cisd.lims.base.ServiceRegistry;
import ch.systemsx.cisd.lims.client.commands.ICommand;
import ch.systemsx.cisd.lims.client.output.IOutputPrinter;
import ch.systemsx.cisd.lims.client.output.OutputType;
import ch.systemsx.cisd.lims.client.parameters.AbstractBufferParameters;
import ch.systemsx.cisd.lims.client.parameters.AbstractParameters;
import ch.systemsx.cisd.lims.client.parameters.IOutputTypeParameters;
import ch.systemsx.cisd.lims.client.table.ITableModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import jline.CandidateListCompletionHandler;
import jline.ConsoleReader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractCommand
implements ICommand {
    private static final String BASE_URL = "base-url";
    private static final String DISPLAY_MORE = "display-more";
    static final String OPENBIS_DEFAULT_PROPERTIES_FILE_NAME = ".openBIS-default";
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(CandidateListCompletionHandler.class.getName());
    static final Properties limsDefaultProperties = new Properties();
    private final String name;
    private final Set<String> aliasNames = new HashSet<String>();
    private ConsoleReader consoleReader;
    static final String INDENTATION;

    static {
        File propertiesFile = new File(OPENBIS_DEFAULT_PROPERTIES_FILE_NAME);
        if (propertiesFile.exists()) {
            FileInputStream stream = null;
            try {
                try {
                    stream = FileUtils.openInputStream((File)propertiesFile);
                    limsDefaultProperties.load(stream);
                }
                catch (IOException iOException) {
                    throw new EnvironmentFailureException(String.format("I/O Exception while loading '%s'", OPENBIS_DEFAULT_PROPERTIES_FILE_NAME));
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            if (ServiceRegistry.getLIMSServiceFactory() == null) {
                ServiceRegistry.setLIMSServiceFactory(RMIBasedLIMSServiceFactory.INSTANCE);
            }
        } else if (ServiceRegistry.getLIMSServiceFactory() == null) {
            ServiceRegistry.setLIMSServiceFactory(RMIBasedLIMSServiceFactory.INSTANCE);
        }
        INDENTATION = StringUtils.repeat(" ", 2);
    }

    AbstractCommand(String name) {
        assert (StringUtils.isNotBlank(name)) : "Put an userful name for the command.";
        this.name = name;
        this.aliasNames.add(name);
    }

    protected void addAliasName(String aliasName) {
        this.aliasNames.add(aliasName);
    }

    protected void printTable(ITableModel model, IOutputTypeParameters parameters) {
        ILinePrinter linePrinter = AbstractCommand.createSimpleLinePrinter();
        IOutputPrinter outputPrinter = AbstractCommand.createPrinter(parameters, linePrinter, "");
        outputPrinter.printTableModel(model, "");
    }

    protected ILinePrinter createPrinter(AbstractBufferParameters parameters) {
        if (parameters.isBufferOutput()) {
            return new PagingLinePrinter(this.getConsoleReader());
        }
        return AbstractCommand.createSimpleLinePrinter();
    }

    protected static ILinePrinter createSimpleLinePrinter() {
        return new SimpleLinePrinter(new BufferedWriter(new OutputStreamWriter(System.out)));
    }

    protected static IOutputPrinter createPrinter(IOutputTypeParameters parameters, ILinePrinter printer, String templateForFirstKeyValuePair) {
        OutputType ouputType = OutputType.TAB_SEPARATED;
        if (parameters.isPrettyPrinted()) {
            ouputType = OutputType.PRETTY;
        }
        return ouputType.createPrinter(printer, templateForFirstKeyValuePair);
    }

    protected final ConsoleReader getConsoleReader() {
        if (this.consoleReader == null) {
            try {
                this.consoleReader = new ConsoleReader();
            }
            catch (IOException ex) {
                throw new EnvironmentFailureException("ConsoleReader could not be instantiated.", ex);
            }
        }
        return this.consoleReader;
    }

    protected final ILIMSService getLIMSService(AbstractParameters parameters) {
        return ServiceRegistry.getLIMSServiceFactory().createLIMSService(this.getServiceURL(parameters));
    }

    protected final String getServiceURL(AbstractParameters parameters) {
        String baseURL = parameters.getBaseURL();
        if (baseURL == null && (baseURL = limsDefaultProperties.getProperty(BASE_URL)) == null) {
            throw new EnvironmentFailureException("Service URL is neither defined as an option nor in the file '.openBIS-default'.");
        }
        return baseURL;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public Set<String> getAliasNames() {
        return Collections.unmodifiableSet(this.aliasNames);
    }

    static /* synthetic */ ResourceBundle access$0() {
        return BUNDLE;
    }

    private static final class PagingLinePrinter
    implements ILinePrinter {
        private static final String MORE = AbstractCommand.access$0().getString("display-more");
        private static final String DELETE_MORE = StringUtils.repeat("\b", MORE.length());
        private final ConsoleReader reader;
        private final int numberLinesPerPage;
        private boolean cancelled;
        private int lineCounter;

        public PagingLinePrinter(ConsoleReader reader) {
            this.reader = reader;
            this.numberLinesPerPage = Math.max(2, reader.getTermheight() - 3);
        }

        public void println(String text) {
            if (this.cancelled) {
                return;
            }
            try {
                if (++this.lineCounter == this.numberLinesPerPage) {
                    this.printAndFlush(MORE);
                    int c = this.reader.readVirtualKey();
                    if (c == 13 || c == 10) {
                        this.lineCounter = this.numberLinesPerPage - 1;
                    } else if (c != 113) {
                        this.lineCounter = 0;
                    }
                    this.printAndFlush(DELETE_MORE);
                    if (c == 113) {
                        this.cancelled = true;
                        return;
                    }
                }
                this.reader.printString(text);
                this.reader.printNewline();
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }

        private void printAndFlush(String text) throws IOException {
            this.reader.printString(text);
            this.reader.flushConsole();
        }
    }
}

