/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.parameters.AbstractParameters;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractRegisterEntityTypeCommand
extends AbstractCommandWithSessionToken {
    protected AbstractRegisterEntityTypeCommand(String commandName) {
        super(commandName);
    }

    public final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(this.getName(), arguments);
        ILIMSService limsService = this.getLIMSService(parameters);
        String code = parameters.getTypeCode();
        String descriptionOrNull = parameters.tryGetTypeDescription();
        this.registerEntity(limsService, sessionToken, code, descriptionOrNull);
        System.out.println("Successfully registered " + this.getEntityName() + " type " + code + ".");
        return 0;
    }

    protected abstract String getEntityName();

    protected abstract void registerEntity(ILIMSService var1, String var2, String var3, String var4);

    private final class Parameters
    extends AbstractParameters {
        Parameters(String commandName, String[] args) {
            super(args, commandName, String.format("<%s-type-code> [<%s-type-description>]", AbstractRegisterEntityTypeCommand.this.getEntityName(), AbstractRegisterEntityTypeCommand.this.getEntityName()));
            if (this.getArgs().size() < 1) {
                System.err.printf("At least the <%s-type-code> needs to be specified.\n", AbstractRegisterEntityTypeCommand.this.getEntityName());
                this.printHelp(true);
            }
        }

        public final String getTypeCode() {
            return StringUtils.upperCase(this.getArgs().get(0));
        }

        public final String tryGetTypeDescription() {
            if (this.getArgs().size() > 1) {
                return this.getArgs().get(1);
            }
            return null;
        }
    }
}

