/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.collections.CollectionStyle;
import ch.systemsx.cisd.common.collections.CollectionUtils;
import ch.systemsx.cisd.common.collections.IToStringConverter;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.io.ILinePrinter;
import ch.systemsx.cisd.lims.base.Experiment;
import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.ListSet;
import ch.systemsx.cisd.lims.base.Procedure;
import ch.systemsx.cisd.lims.base.Sample;
import ch.systemsx.cisd.lims.base.SampleComponent;
import ch.systemsx.cisd.lims.base.SampleComponentsLayout;
import ch.systemsx.cisd.lims.base.SampleCriteria;
import ch.systemsx.cisd.lims.base.SampleGeneration;
import ch.systemsx.cisd.lims.base.SampleType;
import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.base.masterplate.MasterPlateLoader;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.client.commands.AbstractInvalidationInfoCommand;
import ch.systemsx.cisd.lims.client.commands.GetControlLayoutInfoCommand;
import ch.systemsx.cisd.lims.client.model.ListSetBasedTableModel;
import ch.systemsx.cisd.lims.client.output.IOutputPrinter;
import ch.systemsx.cisd.lims.client.parameters.AbstractBufferParameters;
import ch.systemsx.cisd.lims.client.utilities.PersonDescriptor;
import ch.systemsx.cisd.lims.client.utilities.SampleDescriptor;
import ch.systemsx.cisd.lims.client.utilities.Utilities;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.lang.BooleanUtils;

public final class GetPlateInfoCommand
extends AbstractInvalidationInfoCommand {
    static final String WRONG_SAMPLE_TYPE_FORMAT = "Given plate code '%s' is a %s. Use command '%s' to display it.";
    static final String NO_PLATE_SPECIFIED = "Exactly one plate code is expected.";
    private static final String NAME = "get-sample-info";
    private static final String ALIAS_NAME = "get-plate-info";
    private static GetPlateInfoCommand instance;

    private GetPlateInfoCommand() {
        super(NAME);
        this.addAliasName(ALIAS_NAME);
    }

    public final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments);
        boolean prettyMode = parameters.isPrettyPrinted();
        ILIMSService limsService = this.getLIMSService(parameters);
        ILinePrinter linePrinter = this.createPrinter(parameters);
        String plateCode = parameters.getPlateCode();
        SampleGeneration generation = limsService.getSampleInfo(sessionToken, plateCode);
        assert (generation != null) : "Sample generation can not be null.";
        SampleType sampleType = generation.getGenerator().getSampleType();
        if (sampleType.isControlLayout()) {
            throw UserFailureException.fromTemplate(WRONG_SAMPLE_TYPE_FORMAT, plateCode, sampleType.getDescription().toLowerCase(), GetControlLayoutInfoCommand.getInstance().getName());
        }
        IOutputPrinter printer = GetPlateInfoCommand.createPrinter(parameters, linePrinter, this.createTemplateForTitleLine(generation));
        this.printGenerationInfo(printer, generation, prettyMode);
        SampleComponentsLayout sampleMergedLayout = limsService.getSampleMergedLayout(sessionToken, plateCode);
        SampleCriteria[] connectedControlSamples = sampleMergedLayout.getConnectedControlSamples();
        this.printInvalidation(printer, generation.getGenerator().getInvalidation(), prettyMode);
        this.printProperties(generation, sessionToken, limsService, printer, prettyMode);
        SampleComponent[] components = sampleMergedLayout.getComponents();
        SampleCriteria mainSample = sampleMergedLayout.getMainSample();
        boolean markControlWells = !this.isControlSample(mainSample);
        ListSet listSet = MasterPlateLoader.createTable(components, markControlWells);
        String header = this.createTableHeader(mainSample, connectedControlSamples);
        ListSetBasedTableModel model = new ListSetBasedTableModel(header, listSet, prettyMode);
        printer.printTableModel(model, "");
        return 0;
    }

    private void printProperties(SampleGeneration generation, String sessionToken, ILIMSService limsService, IOutputPrinter printer, boolean prettyMode) {
        if (generation == null || generation.getGenerator() == null) {
            return;
        }
        Sample sample = generation.getGenerator();
        SimpleEntityProperty[] properties = sample.getProperties();
        if (properties != null) {
            Arrays.sort(properties, SimpleEntityPropertyComparator.INSTANCE);
            SimpleEntityProperty[] simpleEntityPropertyArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                SimpleEntityProperty property = simpleEntityPropertyArray[n2];
                String name = prettyMode ? property.getUserLabel() : property.getCode();
                printer.printKeyValuePair(name, property.getUntypedValue());
                ++n2;
            }
        }
    }

    private String createTemplateForTitleLine(SampleGeneration generation) {
        if (generation.getGenerator().getInvalidation() == null) {
            return "<<<Plate Information for %s '%s'>>>";
        }
        return "<<<Plate Information for %s '%s' [INVALID PLATE]>>>";
    }

    private boolean isControlSample(SampleCriteria sample) {
        return sample.getSampleTypeCode().equals(SampleTypeCode.CONTROL_LAYOUT.getCode());
    }

    private String createTableHeader(SampleCriteria mainSample, SampleCriteria[] connectedControlSamples) {
        String header = "Plate layout";
        if (connectedControlSamples.length > 0) {
            header = String.valueOf(header) + String.format(" (control layout marked with a star)", new Object[0]);
        }
        return header;
    }

    private void printGenerationInfo(IOutputPrinter printer, SampleGeneration generation, boolean prettyMode) {
        Sample generator = generation.getGenerator();
        printer.printKeyValuePair(FieldName.CODE.getName(prettyMode), generator.getCode());
        assert (generator.getRegistrationDate() != null);
        assert (generator.getRegistrator() != null);
        printer.printKeyValuePair(FieldName.TYPE_CODE.getName(prettyMode), generator.getSampleType().getCode());
        PersonDescriptor.printKeyValueRegisterer(printer, generator.getRegistrator(), prettyMode);
        printer.printKeyValuePair(FieldName.REGISTRATION_DATE.getName(prettyMode), Utilities.formatDate(generator.getRegistrationDate()));
        SampleDescriptor.printKeyValueSampleHierarchy(printer, prettyMode, generator);
        Object[] generated = generation.getGenerated();
        Arrays.sort(generated);
        printer.printKeyValuePair(FieldName.GENERATED_PLATES.getName(prettyMode), this.renderGenerated((Sample[])generated));
        this.printExperimentDescription(printer, generator, prettyMode);
        Boolean inconsistent = generator.getInconsistent();
        printer.printKeyValuePair(FieldName.CONSISTENT.getName(prettyMode), inconsistent == null ? null : BooleanUtils.toStringYesNo(inconsistent == false));
    }

    private final void printExperimentDescription(IOutputPrinter printer, Sample sample, boolean prettyMode) {
        Procedure procedure = sample.getProcedure();
        String experimentCode = null;
        String projectCode = null;
        if (procedure != null) {
            Experiment experiment = procedure.getExperiment();
            assert (experiment != null) : "Experiment must exist if procedure present.";
            assert (experiment.getCode() != null) : "Experiment code can not be null.";
            assert (experiment.getProject() != null) : "Project can not be null.";
            assert (experiment.getProject().getCode() != null) : "Project code can not be null.";
            experimentCode = experiment.getCode();
            projectCode = experiment.getProject().getCode();
        }
        printer.printKeyValuePair(FieldName.EXPERIMENT.getName(prettyMode), experimentCode);
        printer.printKeyValuePair(FieldName.PROJECT.getName(prettyMode), projectCode);
    }

    private String renderGenerated(Sample[] generated) {
        return generated.length == 0 ? null : CollectionUtils.abbreviate(generated, 10, true, new IToStringConverter<Sample>(){

            @Override
            public final String toString(Sample sample) {
                return sample.getCode();
            }
        }, CollectionStyle.NO_BOUNDARY);
    }

    public static final synchronized GetPlateInfoCommand getInstance() {
        if (instance == null) {
            instance = new GetPlateInfoCommand();
        }
        return instance;
    }

    private static final class Parameters
    extends AbstractBufferParameters {
        Parameters(String[] args) {
            super(args, GetPlateInfoCommand.NAME, "<plate-code>");
            if (this.getArgs().size() != 1) {
                System.err.println(GetPlateInfoCommand.NO_PLATE_SPECIFIED);
                this.printHelp(true);
            }
        }

        final String getPlateCode() {
            return this.getArgs().get(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SimpleEntityPropertyComparator
    implements Comparator<SimpleEntityProperty> {
        static final SimpleEntityPropertyComparator INSTANCE = new SimpleEntityPropertyComparator();

        private SimpleEntityPropertyComparator() {
        }

        @Override
        public final int compare(SimpleEntityProperty o1, SimpleEntityProperty o2) {
            assert (o1 != null) : "Unspecified SimpleEntityProperty";
            assert (o2 != null) : "Unspecified SimpleEntityProperty";
            return o1.getUserLabel().compareTo(o2.getUserLabel());
        }
    }
}

