/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.VocabularyTerm;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.model.VocabularyTermTableModel;
import ch.systemsx.cisd.lims.client.parameters.OutputTypeParameters;

public final class GetVocabularyInfoCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "get-vocabulary-info";
    private static final String NO_VOCABULARY_SPECIFIED = "No vocabulary code specified.";
    private static GetVocabularyInfoCommand instance;

    private GetVocabularyInfoCommand() {
        super(NAME);
    }

    public final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        String vocabularyCode;
        Parameters parameters = new Parameters(arguments);
        ILIMSService limsService = this.getLIMSService(parameters);
        VocabularyTerm[] vocabularyTerms = limsService.listVocabularyTerms(sessionToken, vocabularyCode = parameters.getVocabularyCode());
        if (vocabularyTerms.length == 0 && parameters.isPrettyPrinted()) {
            System.out.println("No vocabulary terms found for vocabulary '" + parameters.getVocabularyCode() + "'.");
        } else {
            VocabularyTermTableModel model = new VocabularyTermTableModel(vocabularyTerms, parameters.isPrettyPrinted());
            this.printTable(model, parameters);
        }
        return 0;
    }

    public static final synchronized GetVocabularyInfoCommand getInstance() {
        if (instance == null) {
            instance = new GetVocabularyInfoCommand();
        }
        return instance;
    }

    private static final class Parameters
    extends OutputTypeParameters {
        public Parameters(String[] args) {
            this(args, SystemExit.SYSTEM_EXIT);
        }

        Parameters(String[] args, IExitHandler exitHandler) {
            super(args, GetVocabularyInfoCommand.NAME, "<vocabulary-code>", exitHandler);
            if (this.getArgs().size() == 0) {
                System.err.println(GetVocabularyInfoCommand.NO_VOCABULARY_SPECIFIED);
                this.printHelp(true);
            } else if (this.getArgs().size() != 1) {
                System.err.println("There needs to be exactly one <vocabulary-code>.");
                this.printHelp(true);
            }
        }

        final String getVocabularyCode() {
            return this.getArgs().get(0);
        }
    }
}

