/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertiesSetter;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.IPropertyObjectFactory;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.commands.BisTabFileLoader;
import ch.systemsx.cisd.lims.client.commands.factory.PropertiesParserObjectFactory;
import ch.systemsx.cisd.lims.client.parameters.AbstractParameters;
import ch.systemsx.cisd.lims.client.utilities.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidatePlatesCommand
extends AbstractCommandWithSessionToken {
    private static final String PLATE_CODE_HEADER = "code";
    private static final String NAME = "invalidate-samples";
    private static final String ALIAS_NAME = "invalidate-plates";
    private static InvalidatePlatesCommand instance;

    private InvalidatePlatesCommand() {
        super(NAME);
        this.addAliasName(ALIAS_NAME);
    }

    public static final synchronized InvalidatePlatesCommand getInstance() {
        if (instance == null) {
            instance = new InvalidatePlatesCommand();
        }
        return instance;
    }

    private static final List<String> loadFromFile(File file) {
        BisTabFileLoader<String> tabFileLoader = new BisTabFileLoader<String>(new IParserObjectFactoryFactory<String>(){

            @Override
            public final IParserObjectFactory<String> createFactory(IPropertyMapper propertyMapper) {
                return new PropertiesParserObjectFactory<String>(propertyMapper, InvalidatePlatesCommand.createPlateCodesFactory());
            }
        });
        return tabFileLoader.load(file);
    }

    private static IPropertyObjectFactory<String> createPlateCodesFactory() {
        return new IPropertyObjectFactory<String>(){

            @Override
            public final IPropertiesSetter<String> createObjectSetter() {
                return new IPropertiesSetter<String>(){
                    private String code = null;

                    @Override
                    public final String getConstructedObject() {
                        if (this.code == null) {
                            throw new UserFailureException("Field code is unset.");
                        }
                        return this.code;
                    }

                    @Override
                    public final void setProperty(String name, String value) {
                        if (name.equals(InvalidatePlatesCommand.PLATE_CODE_HEADER)) {
                            if (this.code != null) {
                                throw new UserFailureException("Duplicated code column.");
                            }
                        } else {
                            throw new UserFailureException("Unknown column: " + name);
                        }
                        this.code = value;
                    }
                };
            }
        };
    }

    private final void printResultDescription(String[] plateCodes) {
        if (plateCodes.length == 1) {
            System.out.println(String.valueOf(plateCodes[0]) + " plate has been successfully invalidated.");
        } else {
            System.out.println("Following samples have been successfully invalidated:");
            int i = 0;
            while (i < plateCodes.length) {
                System.out.println(plateCodes[i]);
                ++i;
            }
            System.out.println("Total number: " + plateCodes.length);
        }
    }

    @Override
    protected final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments);
        String invalidationReasonOrNull = parameters.tryGetInvalidationReason();
        String[] plateNames = InvalidatePlatesCommand.getPlateNames(parameters);
        ILIMSService limsService = this.getLIMSService(parameters);
        String[] plateCodes = limsService.invalidateSamples(sessionToken, plateNames, invalidationReasonOrNull);
        this.printResultDescription(plateCodes);
        return 0;
    }

    static final String[] getPlateNames(Parameters parameters) {
        ArrayList<String> plateNames = new ArrayList<String>(parameters.getPlateNames());
        File plateNamesFileOrNull = parameters.tryGetPlateNamesFile();
        if (plateNamesFileOrNull != null) {
            plateNames.addAll(InvalidatePlatesCommand.loadFromFile(plateNamesFileOrNull));
        }
        return plateNames.toArray(new String[plateNames.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Parameters
    extends AbstractParameters {
        @Option(name="r", longName="invalidation-reason", metaVar="<invalidation-reason>", usage="Description of the invalidation reason")
        private String invalidationReasonOrNull;
        @Option(name="f", longName="sample-names-file", metaVar="<file-name>", usage="File with sample names (one per line)")
        private String plateNamesFileOrNull;

        public Parameters(String[] args) {
            this(args, SystemExit.SYSTEM_EXIT);
        }

        Parameters(String[] args, IExitHandler exitHandler) {
            super(args, InvalidatePlatesCommand.this.getName(), "[<sample-name(s)>]", exitHandler);
            if (this.plateNamesFileOrNull == null && this.getArgs().size() == 0) {
                this.printError("No samples to invalidate were specified");
            }
        }

        private final void printError(String msg) {
            System.err.println(msg);
            this.printHelp(true);
        }

        final File tryGetPlateNamesFile() {
            return this.plateNamesFileOrNull == null ? null : Utilities.getFileCheckAccesible(this.plateNamesFileOrNull);
        }

        final List<String> getPlateNames() {
            return this.getArgs();
        }

        final String tryGetInvalidationReason() {
            return this.invalidationReasonOrNull;
        }
    }
}

