/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.collections.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.PlainMaterial;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.commands.IEntityTypeCodeProvider;
import ch.systemsx.cisd.lims.client.model.PlainMaterialTableModel;
import ch.systemsx.cisd.lims.client.output.IOutputPrinter;
import ch.systemsx.cisd.lims.client.parameters.PatternAndLimitParameters;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public final class ListMaterialsCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "list-materials";
    private static ListMaterialsCommand instance;

    private ListMaterialsCommand() {
        super(NAME);
    }

    public final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        String[] patterns;
        String code;
        Parameters parameters = new Parameters(arguments);
        ILIMSService limsService = this.getLIMSService(parameters);
        PlainMaterial[] materials = limsService.listMaterials(sessionToken, code = parameters.getEntityTypeCode(), patterns = parameters.getPatterns(), parameters.getLimitFilter());
        int numberOfMaterials = materials.length;
        if (numberOfMaterials == 0 && parameters.isPrettyPrinted()) {
            this.printNothingFound(code, patterns);
            return 0;
        }
        this.sortById(materials);
        PlainMaterialTableModel model = new PlainMaterialTableModel(materials, null, parameters.isPrettyPrinted());
        IOutputPrinter outputPrinter = ListMaterialsCommand.createPrinter(parameters, this.createPrinter(parameters), "");
        outputPrinter.printTableModel(model, "");
        return 0;
    }

    private void printNothingFound(String code, String[] patterns) {
        StringBuilder builder = new StringBuilder();
        builder.append("No material with type code '").append(code).append("'");
        if (patterns.length > 0) {
            builder.append(" and patterns '").append(CollectionUtils.abbreviate(patterns, -1)).append("'");
        }
        builder.append(" has been found in the database.");
        System.out.println(builder);
    }

    private void sortById(PlainMaterial[] studyObjects) {
        Arrays.sort(studyObjects);
    }

    public static final synchronized ListMaterialsCommand getInstance() {
        if (instance == null) {
            instance = new ListMaterialsCommand();
        }
        return instance;
    }

    private static final class Parameters
    extends PatternAndLimitParameters
    implements IEntityTypeCodeProvider {
        Parameters(String[] args) {
            super(args, ListMaterialsCommand.NAME, "<material-type-code> [<material-code pattern(s)>]", 1);
            if (this.getArgs().size() < 1) {
                System.err.println("At least the <material-type-code> needs to be specified.");
                this.printHelp(true);
            }
        }

        public final String getEntityTypeCode() {
            return StringUtils.upperCase(this.getArgs().get(0));
        }
    }
}

