/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.collections.FilteredList;
import ch.systemsx.cisd.common.collections.Validator;
import ch.systemsx.cisd.lims.base.EntityTypeMandatorilyRelation;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.PropertyTypeEntityTypeRelation;
import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.client.commands.AbstractListEntityPropertyTypesCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPlatePropertyTypesCommand
extends AbstractListEntityPropertyTypesCommand {
    private static final String NAME = "list-sample-property-types";
    private static final String ALIAS_NAME = "list-plate-property-types";
    private static ListPlatePropertyTypesCommand instance;
    private final Validator<EntityTypeMandatorilyRelation> validator;

    ListPlatePropertyTypesCommand() {
        this(NAME, ListPlatePropertyTypesCommand.getUnsupportedSampleTypes(), false);
        this.addAliasName(ALIAS_NAME);
    }

    ListPlatePropertyTypesCommand(String name, SampleTypeCode[] sampleList, boolean isWhiteList) {
        super(name);
        this.validator = new EntityTypeRelationValidator(sampleList, isWhiteList);
    }

    private static final SampleTypeCode[] getUnsupportedSampleTypes() {
        return new SampleTypeCode[]{SampleTypeCode.CONTROL_LAYOUT};
    }

    private static final <T> List<T> createModifiableList(T[] objects) {
        return new ArrayList(Arrays.asList(objects));
    }

    public static synchronized ListPlatePropertyTypesCommand getInstance() {
        if (instance == null) {
            instance = new ListPlatePropertyTypesCommand();
        }
        return instance;
    }

    @Override
    final PropertyTypeEntityTypeRelation[] listPropertyTypeRelations(String sessionToken, ILIMSService limsService, EntityKind entityKind) {
        List<PropertyTypeEntityTypeRelation> propertyTypeRelations = ListPlatePropertyTypesCommand.createModifiableList(super.listPropertyTypeRelations(sessionToken, limsService, entityKind));
        for (PropertyTypeEntityTypeRelation propertyTypeEntityTypeRelation : propertyTypeRelations) {
            List<EntityTypeMandatorilyRelation> filteredList = FilteredList.decorate(ListPlatePropertyTypesCommand.createModifiableList(propertyTypeEntityTypeRelation.getRelations()), this.validator);
            propertyTypeEntityTypeRelation.setRelations(filteredList.toArray(EntityTypeMandatorilyRelation.EMPTY_ARRAY));
        }
        return propertyTypeRelations.toArray(PropertyTypeEntityTypeRelation.EMPTY_ARRAY);
    }

    @Override
    String getEntityKindLabel(EntityKind entityKind) {
        return "Sample";
    }

    @Override
    final EntityKind getEntityKind() {
        return EntityKind.SAMPLE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntityTypeRelationValidator
    implements Validator<EntityTypeMandatorilyRelation> {
        private final Set<String> set = new HashSet<String>();
        private final boolean isWhiteList;

        EntityTypeRelationValidator(SampleTypeCode[] list, boolean isWhiteList) {
            if (list != null) {
                SampleTypeCode[] sampleTypeCodeArray = list;
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    SampleTypeCode typeCode = sampleTypeCodeArray[n2];
                    this.set.add(typeCode.getCode());
                    ++n2;
                }
            }
            this.isWhiteList = isWhiteList;
        }

        @Override
        public final boolean isValid(EntityTypeMandatorilyRelation object) {
            String entityTypeCode = object.getEntityType().getCode();
            if (this.set.contains(entityTypeCode)) {
                return this.isWhiteList;
            }
            return !this.isWhiteList;
        }
    }
}

