/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.client.commands.AbstractCommand;
import ch.systemsx.cisd.lims.client.commands.Credentials;
import ch.systemsx.cisd.lims.client.parameters.AbstractParameters;
import ch.systemsx.cisd.lims.client.utilities.Constants;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.kohsuke.args4j.Option;

public final class LoginCommand
extends AbstractCommand {
    private static final String NAME = "login";
    private static LoginCommand instance;

    private LoginCommand() {
        super(NAME);
    }

    public static final synchronized LoginCommand getInstance() {
        if (instance == null) {
            instance = new LoginCommand();
        }
        return instance;
    }

    public final int execute(String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments);
        Credentials credentials = parameters.getCredentials();
        try {
            credentials = this.getCredentials(credentials);
        }
        catch (IOException ex) {
            throw new EnvironmentFailureException("I/O Exception while getting credentials.", ex);
        }
        if (credentials == null) {
            System.err.println("Credentials are not valid.");
            return 1;
        }
        ILIMSService limsService = this.getLIMSService(parameters);
        int serviceVersion = limsService.getVersion();
        if (18 != serviceVersion) {
            System.err.println("This client has the wrong service version for the server (client: 18, server: " + serviceVersion + ").");
            return 2;
        }
        String sessionToken = limsService.authenticate(credentials.getUserName(), credentials.getPassword());
        return LoginCommand.processSessionToken(sessionToken, credentials.getUserName());
    }

    private static final int processSessionToken(String sessionToken, String user) {
        if (sessionToken == null) {
            System.out.println("Authentication failed for user " + user);
            return 1;
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(Constants.SESSION_TOKEN_FILE);
            writer.write(sessionToken);
            System.out.println("Successfully authenticated.");
        }
        catch (IOException e) {
            try {
                throw new CheckedExceptionTunnel(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        return 0;
    }

    private final Credentials getCredentials(Credentials initial) throws IOException {
        String password;
        String userName = initial.getUserName();
        if (userName == null) {
            while ((userName = this.getConsoleReader().readLine("User: ")) == null) {
            }
        }
        if ((password = initial.getPassword()) == null) {
            while ((password = this.getConsoleReader().readLine("Password: ", Character.valueOf('*'))) == null) {
            }
        }
        return new Credentials(userName, password);
    }

    private static final class Parameters
    extends AbstractParameters {
        @Option(name="u", longName="username", usage="User login name")
        private String username;
        @Option(name="p", longName="password", usage="User login password")
        private String password;
        private Credentials credentials;

        public Parameters(String[] args) {
            super(args, LoginCommand.NAME);
            this.credentials = new Credentials(this.username, this.password);
        }

        Credentials getCredentials() {
            return this.credentials;
        }
    }
}

