/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.types.BooleanOrUnknown;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.ExternalData;
import ch.systemsx.cisd.lims.base.FileFormatType;
import ch.systemsx.cisd.lims.base.IETLLIMSService;
import ch.systemsx.cisd.lims.base.LocatorType;
import ch.systemsx.cisd.lims.base.ObservableType;
import ch.systemsx.cisd.lims.base.ObservableTypeCode;
import ch.systemsx.cisd.lims.base.ProcedureTypeCode;
import ch.systemsx.cisd.lims.base.ServiceRegistry;
import ch.systemsx.cisd.lims.base.util.StorageFormat;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.parameters.AbstractParameters;
import java.util.Date;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;

public final class RegisterDataSetCommand
extends AbstractCommandWithSessionToken {
    static final String ODD_ARGUMENT_NUMBER = "There needs to be zero or one <project-code> <experiment-code>, one <sample-code>, one <relative-data-set-path> and one <storage-format-code>.";
    private static final String NAME = "register-data-set";
    private static RegisterDataSetCommand instance;

    private RegisterDataSetCommand() {
        super(NAME);
    }

    public static final synchronized RegisterDataSetCommand getInstance() {
        if (instance == null) {
            instance = new RegisterDataSetCommand();
        }
        return instance;
    }

    private final IETLLIMSService getETLLIMSService(AbstractParameters parameters) {
        return ServiceRegistry.getLIMSServiceFactory().createETLLIMSService(this.getServiceURL(parameters));
    }

    public int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments);
        IETLLIMSService limsService = this.getETLLIMSService(parameters);
        ExperimentIdentifier experimentIdentifier = null;
        if (parameters.tryGetProjectCode() != null && parameters.tryGetExperimentCode() != null) {
            experimentIdentifier = new ExperimentIdentifier(parameters.tryGetProjectCode(), parameters.tryGetExperimentCode());
        }
        String relativeDataSetPath = parameters.getRelativeDataSetPath();
        String sampleCode = parameters.getSampleCode();
        ExternalData externalData = new ExternalData();
        externalData.setLocation(relativeDataSetPath);
        String storageFormatCode = parameters.getStorageFormatCode();
        StorageFormat storageFormat = StorageFormat.tryGetFromCode(storageFormatCode);
        if (storageFormat == null) {
            throw new IllegalArgumentException(String.format("Unknown storage format code '%s'.", storageFormatCode));
        }
        externalData.setCode(limsService.createDataSetCode(sessionToken));
        externalData.setStorageFormat(storageFormat);
        externalData.setLocatorType(new LocatorType("RELATIVE_LOCATION"));
        externalData.setObservableType(new ObservableType(parameters.getObservableTypeCode()));
        externalData.setFileFormatType(new FileFormatType(parameters.getFileFormatTypeCode()));
        externalData.setProductionDate(new Date());
        externalData.setComplete(parameters.getComplete());
        limsService.registerDataSet(sessionToken, experimentIdentifier, sampleCode, parameters.getProcedureTypeCode(), externalData);
        StringBuilder stringBuilder = new StringBuilder("Relative path '");
        stringBuilder.append(relativeDataSetPath).append("' for sample '").append(sampleCode).append("'");
        if (experimentIdentifier != null) {
            stringBuilder.append(" and experiment '").append(experimentIdentifier).append("'");
        }
        stringBuilder.append(" has been successfully stored.");
        System.out.println(stringBuilder);
        return 0;
    }

    private static final class Parameters
    extends AbstractParameters {
        @Option(name="p", longName="procedure-type", usage="Procedure type code (default is 'DATA_ACQUISITION')")
        private String procedureTypeCode;
        @Option(name="o", longName="observable-type", usage="Observable type code (default is 'HCS_IMAGE')")
        private String observableTypeCode;
        @Option(name="f", longName="fileformat-type", usage="File format type code (default is 'TIFF')")
        private String fileFormatTypeCode;
        private BooleanOrUnknown complete;

        public Parameters(String[] args) {
            this(args, SystemExit.SYSTEM_EXIT);
        }

        Parameters(String[] args, IExitHandler exitHandler) {
            super(args, RegisterDataSetCommand.NAME, "[<project-code> <experiment-code>] <sample-code> <relative-data-set-path> <storage-format-code>", exitHandler);
            int size = this.getArgs().size();
            if (size != 3 && size != 5) {
                System.err.println(RegisterDataSetCommand.ODD_ARGUMENT_NUMBER);
                this.printHelp(true);
            }
        }

        @Option(name="c", longName="is-complete", usage="Whether the data set is complete. Can be TRUE, FALSE, or UNKNOWN")
        void setComplete(String isCompleteString) throws CmdLineException {
            if (isCompleteString.equalsIgnoreCase("TRUE")) {
                this.complete = BooleanOrUnknown.TRUE;
            } else if (isCompleteString.equalsIgnoreCase("FALSE")) {
                this.complete = BooleanOrUnknown.FALSE;
            } else if (isCompleteString.equalsIgnoreCase("UNKNOWN")) {
                this.complete = BooleanOrUnknown.UNKNOWN;
            } else {
                throw new CmdLineException("Illegal option value '" + isCompleteString + "'.");
            }
        }

        final String getSampleCode() {
            return this.getArgs().get(this.getArgs().size() - 3);
        }

        final String getRelativeDataSetPath() {
            return this.getArgs().get(this.getArgs().size() - 2);
        }

        final String getStorageFormatCode() {
            return this.getArgs().get(this.getArgs().size() - 1);
        }

        final String tryGetProjectCode() {
            if (this.getArgs().size() != 5) {
                return null;
            }
            return this.getArgs().get(0);
        }

        final String tryGetExperimentCode() {
            if (this.getArgs().size() != 5) {
                return null;
            }
            return this.getArgs().get(1);
        }

        final String getProcedureTypeCode() {
            return this.procedureTypeCode == null ? ProcedureTypeCode.DATA_ACQUISITION.getCode() : this.procedureTypeCode;
        }

        final String getObservableTypeCode() {
            String code = ObservableTypeCode.HCS_IMAGE.getCode();
            if (this.observableTypeCode != null) {
                code = this.observableTypeCode;
            }
            return code;
        }

        final String getFileFormatTypeCode() {
            String code = "TIFF";
            if (this.fileFormatTypeCode != null) {
                code = this.fileFormatTypeCode;
            }
            return code;
        }

        BooleanOrUnknown getComplete() {
            return this.complete == null ? BooleanOrUnknown.UNKNOWN : this.complete;
        }
    }
}

