/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.lims.base.EntityType;
import ch.systemsx.cisd.lims.client.commands.AbstractFileParameters;
import ch.systemsx.cisd.lims.client.commands.AbstractRegisterMaterialCommand;

public class RegisterMaterialsCommand
extends AbstractRegisterMaterialCommand {
    private static final String NAME = "register-materials";
    private static RegisterMaterialsCommand instance;

    public static final synchronized RegisterMaterialsCommand getInstance() {
        if (instance == null) {
            instance = new RegisterMaterialsCommand();
        }
        return instance;
    }

    RegisterMaterialsCommand() {
        super(NAME);
    }

    protected Parameters getParameters() {
        return (Parameters)super.getParameters();
    }

    protected EntityType getMaterialType() {
        return this.getParameters().getMaterialType();
    }

    protected Parameters createParameters(String[] arguments, String materialDescription) {
        return new Parameters(arguments);
    }

    protected boolean isInhibitorMandatory() {
        return "OLIGO".equals(this.getMaterialType().getCode());
    }

    protected class Parameters
    extends AbstractFileParameters {
        private final EntityType materialType;

        Parameters(String[] args) {
            super(args, RegisterMaterialsCommand.this.getName(), "<material-type-code> <material-file>", SystemExit.SYSTEM_EXIT);
            if (this.getArgs().size() != 2) {
                System.err.println("Exactly one material type code and one material file must be specified.");
                this.printHelp(true);
            }
            String materialTypeCode = this.getArgs().get(0).toUpperCase();
            this.materialType = new EntityType(materialTypeCode, "materials of type '" + materialTypeCode + "'");
        }

        public EntityType getMaterialType() {
            return this.materialType;
        }

        protected int getFileArgumentIndex() {
            return 1;
        }
    }
}

