/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.IPropertyObjectFactory;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.NewSample;
import ch.systemsx.cisd.lims.base.SampleType;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.base.properties.EntityPropertiesSchema;
import ch.systemsx.cisd.lims.base.properties.IEntityPropertiesSchema;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityPropertySchema;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.commands.AbstractFileParameters;
import ch.systemsx.cisd.lims.client.commands.BisTabFileLoader;
import ch.systemsx.cisd.lims.client.commands.SamplePropertiesSetter;
import ch.systemsx.cisd.lims.client.commands.factory.PropertiesParserObjectFactory;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RegisterSamplesCommand
extends AbstractCommandWithSessionToken {
    private static RegisterSamplesCommand instance;

    public static final synchronized RegisterSamplesCommand getInstance() {
        if (instance == null) {
            instance = new RegisterSamplesCommand();
        }
        return instance;
    }

    private RegisterSamplesCommand() {
        super("register-samples");
    }

    @Override
    protected int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments);
        ILIMSService limsService = this.getLIMSService(parameters);
        File file = parameters.getFile();
        String sampleTypeCode = parameters.getSampleTypeCode();
        System.out.println("Register samples from '" + file.getAbsolutePath() + "'.");
        List<NewSample> newSamples = this.createTabFileLoader(sessionToken, sampleTypeCode, limsService).load(file);
        this.enrichSample(newSamples, sampleTypeCode);
        limsService.registerSamples(sessionToken, newSamples.toArray(new NewSample[newSamples.size()]));
        for (NewSample newSample : newSamples) {
            System.out.printf("  New sample '%s' successfully registered.\n", this.describeSample(newSample));
        }
        return 0;
    }

    private BisTabFileLoader<NewSample> createTabFileLoader(String sessionToken, String sampleTypeCode, ILIMSService limsService) {
        SimpleEntityPropertySchema[] simpleSchema = limsService.listEntityPropertyTypes(sessionToken, EntityKind.SAMPLE, sampleTypeCode);
        final IEntityPropertiesSchema schema = EntityPropertiesSchema.createFromSimple(simpleSchema);
        SampleType sampleType = new SampleType();
        sampleType.setCode(sampleTypeCode);
        final IPropertyObjectFactory<NewSample> factory = SamplePropertiesSetter.createFactory(sampleType, schema, false);
        IParserObjectFactoryFactory<NewSample> factoryFactory = new IParserObjectFactoryFactory<NewSample>(){

            @Override
            public IParserObjectFactory<NewSample> createFactory(IPropertyMapper propertyMapper) throws ParserException {
                return new PropertiesParserObjectFactory<NewSample>(propertyMapper, schema, factory);
            }
        };
        return new BisTabFileLoader<NewSample>(factoryFactory);
    }

    private void enrichSample(List<NewSample> newSamples, String sampleTypeCode) {
        for (NewSample newSample : newSamples) {
            newSample.setSampleTypeCode(sampleTypeCode);
        }
    }

    private final String describeSample(NewSample newSample) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(newSample.getSampleTypeCode());
        builder.append("=");
        builder.append(newSample.getSampleCriteria());
        builder.append(",derived from=").append(newSample.getGeneratedFrom());
        builder.append("]");
        return builder.toString();
    }

    protected final class Parameters
    extends AbstractFileParameters {
        public Parameters(String[] args) {
            this(args, SystemExit.SYSTEM_EXIT);
        }

        Parameters(String[] args, IExitHandler exitHandler) {
            super(args, RegisterSamplesCommand.this.getName(), "<sample-type-code> <sample-file>", exitHandler);
            if (this.getArgs().size() != 2) {
                System.err.println("Exactly one sample type code and one sample file must be specified.");
                this.printHelp(true);
            }
        }

        public String getSampleTypeCode() {
            return this.getArgs().get(0);
        }

        protected int getFileArgumentIndex() {
            return 1;
        }
    }
}

