/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.SearchResult;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.model.SearchTableModel;
import ch.systemsx.cisd.lims.client.parameters.AbstractBufferParameters;

public final class SearchCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "search";
    private static SearchCommand instance;

    private SearchCommand() {
        super(NAME);
    }

    public final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        boolean emptySearchResult;
        Parameters parameters = new Parameters(arguments);
        ILIMSService limsService = this.getLIMSService(parameters);
        SearchResult searchResult = limsService.search(sessionToken, parameters.getArgs().get(0));
        boolean bl = emptySearchResult = searchResult.getExperiments().length == 0 && searchResult.getSamples().length == 0 && searchResult.getMaterials().length == 0;
        if (emptySearchResult && parameters.isPrettyPrinted()) {
            System.out.println("No search hits have been found for the given term.");
            return 0;
        }
        SearchTableModel model = new SearchTableModel(searchResult, null, parameters.isPrettyPrinted());
        this.printTable(model, parameters);
        return 0;
    }

    public static final synchronized SearchCommand getInstance() {
        if (instance == null) {
            instance = new SearchCommand();
        }
        return instance;
    }

    private static final class Parameters
    extends AbstractBufferParameters {
        Parameters(String[] args) {
            super(args, SearchCommand.NAME, "<search-term>");
            if (this.getArgs().size() != 1) {
                System.err.println("No search term specified");
                this.printHelp(true);
            }
        }

        final String getPlateCode() {
            return this.getArgs().get(0);
        }
    }
}

