/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands.factory;

import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IPropertiesSetter;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.IPropertyModel;
import ch.systemsx.cisd.common.parser.IPropertyObjectFactory;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.lims.base.properties.IEntityPropertiesSchema;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesParserObjectFactory<E>
implements IParserObjectFactory<E> {
    private final IPropertyMapper propertyMapper;
    private final IPropertyObjectFactory<E> objectFactory;

    public PropertiesParserObjectFactory(IPropertyMapper propertyMapper, IPropertyObjectFactory<E> objectFactory) {
        this.propertyMapper = propertyMapper;
        this.objectFactory = objectFactory;
    }

    public PropertiesParserObjectFactory(IPropertyMapper propertyMapper, IEntityPropertiesSchema schema, IPropertyObjectFactory<E> objectFactory) {
        this(propertyMapper, objectFactory);
        String[] names;
        String[] stringArray = names = schema.getAllNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (schema.getPropertySchema(name).getIsMandatory() && !propertyMapper.containsPropertyName(name.toLowerCase())) {
                throw new ParserException("Missing mandatory column '" + name + "'.");
            }
            ++n2;
        }
    }

    private String getPropertyValue(String[] lineTokens, IPropertyModel propertyModel) {
        int column = propertyModel.getColumn();
        if (column >= lineTokens.length) {
            String name = propertyModel.getName();
            String mergedTokens = PropertiesParserObjectFactory.merge(lineTokens);
            throw new ParserException(String.format("Value for column '%s' cannot be found in line '%s'", name, mergedTokens));
        }
        return lineTokens[column];
    }

    private static String merge(String[] lineTokens) {
        StringBuffer sb = new StringBuffer();
        String[] stringArray = lineTokens;
        int n = lineTokens.length;
        int n2 = 0;
        while (n2 < n) {
            String col = stringArray[n2];
            sb.append("<");
            sb.append(col);
            sb.append("> ");
            ++n2;
        }
        return sb.toString();
    }

    @Override
    public final E createObject(String[] lineTokens) throws ParserException {
        IPropertiesSetter<E> setter = this.objectFactory.createObjectSetter();
        Set<String> propertyNames = this.propertyMapper.getAllPropertyNames();
        for (String name : propertyNames) {
            IPropertyModel propertyModel = this.propertyMapper.getPropertyModel(name);
            String propertyValue = this.getPropertyValue(lineTokens, propertyModel);
            setter.setProperty(name, propertyValue);
        }
        return setter.getConstructedObject();
    }
}

