/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.model;

import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.Sample;
import ch.systemsx.cisd.lims.client.model.GenericSampleBasicTableModel;
import ch.systemsx.cisd.lims.client.utilities.SampleDescriptor;

public class PlateSampleBasicTableModel
extends GenericSampleBasicTableModel {
    private static final int COLUMN_COUNT = 12;

    public PlateSampleBasicTableModel(Sample[] samples, String header, boolean prettyMode) {
        super(samples, header, prettyMode);
    }

    public int getColumnCount() {
        return 12;
    }

    protected FieldName getColumnDesc(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return FieldName.CODE;
            }
            case 1: {
                return FieldName.TYPE_CODE;
            }
            case 2: {
                return FieldName.INVALID;
            }
            case 3: {
                return FieldName.REGISTRATOR;
            }
            case 4: {
                return FieldName.REGISTRATION_DATE;
            }
            case 5: {
                return FieldName.CONTROL_LAYOUT;
            }
            case 6: {
                return FieldName.MASTER_PLATE;
            }
            case 7: {
                return FieldName.MASTER_CONTROL_LAYOUT;
            }
            case 8: {
                return FieldName.DILUTION_PLATE;
            }
            case 9: {
                return FieldName.DILUTION_CONTROL_LAYOUT;
            }
            case 10: {
                return FieldName.CELL_PLATE;
            }
            case 11: {
                return FieldName.CELL_CONTROL_LAYOUT;
            }
        }
        throw new IllegalArgumentException("invalid table column index " + columnIndex);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        this.assertColumnIndex(columnIndex);
        Sample sample = this.getSample(rowIndex);
        switch (columnIndex) {
            case 0: {
                return SampleDescriptor.getSampleCode(sample);
            }
            case 1: {
                return PlateSampleBasicTableModel.getSampleTypeCode(sample);
            }
            case 2: {
                if (sample.getInvalidation() != null) {
                    return true;
                }
                return false;
            }
            case 3: {
                return sample.getRegistrator();
            }
            case 4: {
                return sample.getRegistrationDate();
            }
            case 5: {
                return SampleDescriptor.getControlLayoutCode(sample);
            }
            case 6: {
                return SampleDescriptor.getMasterPlateCode(sample);
            }
            case 7: {
                return SampleDescriptor.getMasterPlateControlLayout(sample);
            }
            case 8: {
                return SampleDescriptor.getDilutionPlateCode(sample);
            }
            case 9: {
                return SampleDescriptor.getDilutionPlateControlLayout(sample);
            }
            case 10: {
                return SampleDescriptor.getCellPlateCode(sample);
            }
            case 11: {
                return SampleDescriptor.getCellPlateControlLayout(sample);
            }
        }
        throw new IllegalArgumentException("invalid table column index " + columnIndex);
    }
}

