/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.utilities.BeanUtils;
import ch.systemsx.cisd.lims.base.ExperimentFileAttachment;
import ch.systemsx.cisd.lims.server.dto.ExperimentFileAttachmentDTO;
import ch.systemsx.cisd.lims.server.dto.PropertyTypeDTO;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;

public final class BeanUtilsConverters {
    private static final BeanUtils.Converter PROPERTY_TYPE_CONVERTER = new PropertyTypeConverter();

    private BeanUtilsConverters() {
    }

    public static final BeanUtils.Converter getPropertyTypeConverter() {
        return PROPERTY_TYPE_CONVERTER;
    }

    public static final BeanUtils.Converter getFilePropertyByteConverter() {
        return new BeanUtils.Converter(){

            public byte[] convertToValue(ExperimentFileAttachment myProperty) {
                try {
                    return Base64.decodeBase64((byte[])myProperty.getValue().getBytes("ASCII"));
                }
                catch (UnsupportedEncodingException ex) {
                    throw new CheckedExceptionTunnel(ex);
                }
            }
        };
    }

    public static final BeanUtils.Converter getFilePropertyStringConverter() {
        return new BeanUtils.Converter(){

            public String convertToValue(ExperimentFileAttachmentDTO myPropertyDto) {
                try {
                    return new String(Base64.encodeBase64((byte[])myPropertyDto.getValue()), "ASCII");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new CheckedExceptionTunnel(ex);
                }
            }
        };
    }

    private static final class PropertyTypeConverter
    implements BeanUtils.Converter {
        private PropertyTypeConverter() {
        }

        public final String convertToType(PropertyTypeDTO sourceBean) {
            return sourceBean.getType().getCode();
        }
    }
}

