/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.common.logging.LogInvocationHandler;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.lims.server.business.EntityPropertyManager;
import ch.systemsx.cisd.lims.server.business.ExperimentManager;
import ch.systemsx.cisd.lims.server.business.FileFormatTypeManager;
import ch.systemsx.cisd.lims.server.business.GenericManager;
import ch.systemsx.cisd.lims.server.business.IEntityPropertyManager;
import ch.systemsx.cisd.lims.server.business.IExperimentManager;
import ch.systemsx.cisd.lims.server.business.IFileFormatTypeManager;
import ch.systemsx.cisd.lims.server.business.IGenericManager;
import ch.systemsx.cisd.lims.server.business.IMaterialManager;
import ch.systemsx.cisd.lims.server.business.IObservableTypeManager;
import ch.systemsx.cisd.lims.server.business.IPersonManager;
import ch.systemsx.cisd.lims.server.business.IProcessingInstructionValidator;
import ch.systemsx.cisd.lims.server.business.IProjectManager;
import ch.systemsx.cisd.lims.server.business.IPropertyTypeManager;
import ch.systemsx.cisd.lims.server.business.ISampleManager;
import ch.systemsx.cisd.lims.server.business.MaterialManager;
import ch.systemsx.cisd.lims.server.business.ObservableTypeManager;
import ch.systemsx.cisd.lims.server.business.PersonManager;
import ch.systemsx.cisd.lims.server.business.ProjectManager;
import ch.systemsx.cisd.lims.server.business.PropertyTypeManager;
import ch.systemsx.cisd.lims.server.business.SampleManager;
import ch.systemsx.cisd.lims.server.business.StrategyFactoryProvider;
import ch.systemsx.cisd.lims.server.business.bo.BusinessObjectFactory;
import ch.systemsx.cisd.lims.server.business.bo.PropertyValueProviderFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.log4j.Level;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainModel {
    private IPersonManager personManager;
    private IMaterialManager materialManager;
    private IEntityPropertyManager entityPropertyManager;
    private IProjectManager projectManager;
    private IExperimentManager experimentManager;
    private ISampleManager sampleManager;
    private IDAOFactory daoFactory;
    private IPropertyTypeManager propertyTypeManager;
    private IObservableTypeManager observableTypeManager;
    private IFileFormatTypeManager fileFormatTypeManager;
    private IGenericManager genericManager;

    public DomainModel(IDAOFactory daoFactory, StrategyFactoryProvider strategyProvider, IMailClient mailClient, IProcessingInstructionValidator processingInstructionValidator) {
        this(daoFactory, strategyProvider, mailClient, processingInstructionValidator, new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }
        });
    }

    public DomainModel(IDAOFactory daoFactory, StrategyFactoryProvider strategyProvider, IMailClient mailClient, IProcessingInstructionValidator processingInstructionValidator, BeanPostProcessor processor) {
        assert (daoFactory != null) : "Undefined DAO Factory";
        assert (strategyProvider != null) : "Undefined strategy factory provider";
        assert (processingInstructionValidator != null) : "Undefined processing instruction validator";
        assert (mailClient != null) : "Undefined mail client";
        this.daoFactory = daoFactory;
        BusinessObjectFactory boFactory = new BusinessObjectFactory(daoFactory, new PropertyValueProviderFactory(daoFactory), strategyProvider);
        this.personManager = this.createLoggingProxy(processor, new PersonManager(daoFactory, strategyProvider, boFactory));
        this.materialManager = this.createLoggingProxy(processor, new MaterialManager(daoFactory, strategyProvider, boFactory));
        this.entityPropertyManager = this.createLoggingProxy(processor, new EntityPropertyManager(daoFactory, strategyProvider, boFactory));
        this.projectManager = this.createLoggingProxy(processor, new ProjectManager(daoFactory, strategyProvider, boFactory));
        this.experimentManager = this.createLoggingProxy(processor, new ExperimentManager(daoFactory, strategyProvider, boFactory, processingInstructionValidator));
        this.sampleManager = this.createLoggingProxy(processor, new SampleManager(daoFactory, strategyProvider, boFactory, mailClient));
        this.propertyTypeManager = this.createLoggingProxy(processor, new PropertyTypeManager(daoFactory, strategyProvider, boFactory));
        this.observableTypeManager = this.createLoggingProxy(processor, new ObservableTypeManager(daoFactory, strategyProvider, boFactory));
        this.fileFormatTypeManager = this.createLoggingProxy(processor, new FileFormatTypeManager(daoFactory, strategyProvider, boFactory));
        this.genericManager = this.createLoggingProxy(processor, new GenericManager(daoFactory, strategyProvider, boFactory));
    }

    private <T> T createLoggingProxy(BeanPostProcessor processor, T manager) {
        Object proxy = processor.postProcessAfterInitialization(manager, "proxy of " + manager.getClass().getName());
        Class<?> clazz = this.getClass();
        LogInvocationHandler invocationHandler = new LogInvocationHandler(proxy, manager.getClass().getSimpleName(), Level.DEBUG, clazz);
        Class<?>[] interfaces = manager.getClass().getInterfaces();
        return this.cast(Proxy.newProxyInstance(clazz.getClassLoader(), interfaces, (InvocationHandler)invocationHandler));
    }

    private <T> T cast(Object proxy) {
        return (T)proxy;
    }

    public final IDAOFactory getDAOFactory() {
        return this.daoFactory;
    }

    public final IPersonManager getPersonManager() {
        return this.personManager;
    }

    public final IMaterialManager getMaterialManager() {
        return this.materialManager;
    }

    public final IEntityPropertyManager getEntityPropertyManager() {
        return this.entityPropertyManager;
    }

    public final IProjectManager getProjectManager() {
        return this.projectManager;
    }

    public ISampleManager getSampleManager() {
        return this.sampleManager;
    }

    public final IExperimentManager getExperimentManager() {
        return this.experimentManager;
    }

    public final IPropertyTypeManager getPropertyTypeManager() {
        return this.propertyTypeManager;
    }

    public final IObservableTypeManager getObservableTypeManager() {
        return this.observableTypeManager;
    }

    public final IFileFormatTypeManager getFileFormatTypeManager() {
        return this.fileFormatTypeManager;
    }

    public final IGenericManager getGenericManager() {
        return this.genericManager;
    }
}

