/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.BeanUtils;
import ch.systemsx.cisd.lims.base.FileFormatType;
import ch.systemsx.cisd.lims.server.business.AbstractManager;
import ch.systemsx.cisd.lims.server.business.IFileFormatTypeManager;
import ch.systemsx.cisd.lims.server.business.ParameterChecker;
import ch.systemsx.cisd.lims.server.business.StrategyFactoryProvider;
import ch.systemsx.cisd.lims.server.business.bo.IBusinessObjectFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dto.FileFormatTypeDTO;
import java.util.List;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.transaction.annotation.Transactional;

final class FileFormatTypeManager
extends AbstractManager
implements IFileFormatTypeManager {
    FileFormatTypeManager(IDAOFactory daoFactory, StrategyFactoryProvider strategyProvider, IBusinessObjectFactory boFactory) {
        super(daoFactory, strategyProvider, boFactory);
    }

    @Transactional
    public FileFormatType[] listFileFormatTypes() {
        List<FileFormatTypeDTO> list = this.daoFactory.getFileFormatTypeDAO().listFileFormatTypes();
        return BeanUtils.createBeanList(FileFormatType.class, list).toArray(new FileFormatType[list.size()]);
    }

    @Transactional
    public void registerFileFormatType(String fileFormatTypeCode, String fileFormatTypeDescription) {
        ParameterChecker.checkIfNotNull(fileFormatTypeCode, "file format type code");
        FileFormatTypeDTO observableType = new FileFormatTypeDTO();
        observableType.setCode(fileFormatTypeCode);
        observableType.setDescription(fileFormatTypeDescription);
        try {
            this.daoFactory.getFileFormatTypeDAO().createType(observableType);
        }
        catch (DataIntegrityViolationException ex) {
            throw UserFailureException.fromTemplate("File format type with code '%s' already exists in the database.", new Object[]{fileFormatTypeCode, ex});
        }
    }
}

