/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.lims.base.SearchHitDescription;
import ch.systemsx.cisd.lims.base.SearchResult;
import ch.systemsx.cisd.lims.server.business.AbstractManager;
import ch.systemsx.cisd.lims.server.business.IGenericManager;
import ch.systemsx.cisd.lims.server.business.StrategyFactoryProvider;
import ch.systemsx.cisd.lims.server.business.bo.IBusinessObjectFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericManager
extends AbstractManager
implements IGenericManager {
    GenericManager(IDAOFactory daoFactory, StrategyFactoryProvider strategyProvider, IBusinessObjectFactory boFactory) {
        super(daoFactory, strategyProvider, boFactory);
    }

    @Override
    public SearchResult search(String searchTerm) {
        Collection<SearchHitDescription> experiments = this.daoFactory.getExperimentDAO().searchForExperiments(searchTerm);
        Collection<SearchHitDescription> samples = this.daoFactory.getSampleDAO().searchForSamples(searchTerm);
        Collection<SearchHitDescription> materials = this.daoFactory.getMaterialDAO().searchForMaterials(searchTerm);
        return new SearchResult(GenericManager.toArray(experiments), GenericManager.toArray(samples), GenericManager.toArray(materials));
    }

    private static SearchHitDescription[] toArray(Collection<SearchHitDescription> results) {
        return results.toArray(new SearchHitDescription[results.size()]);
    }
}

